/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.warp;

public class WarpReader {
    private byte[] buf;
    private int pos;

    public WarpReader() {
        this(null);
    }

    public WarpReader(byte[] buf) {
        this.reset(buf);
    }

    public int readShort() {
        if (this.buf == null) {
            throw new NullPointerException("No buffer");
        }
        if (this.pos + 2 > this.buf.length) {
            throw new IllegalStateException("Not enough data (" + this.pos + "/" + this.buf.length + ")");
        }
        int x = this.buf[this.pos++] & 0xFF;
        x = x << 8 | this.buf[this.pos++] & 0xFF;
        return x;
    }

    public String readString() {
        if (this.buf == null) {
            throw new NullPointerException("No buffer");
        }
        int len = this.readShort();
        if (this.pos + len > this.buf.length) {
            throw new IllegalStateException("Not enough data (" + this.pos + "+" + len + "=" + this.buf.length + ")");
        }
        String s = new String(this.buf, this.pos, len);
        this.pos += len;
        return s;
    }

    public void reset(byte[] buf) {
        this.buf = buf;
        this.pos = 0;
    }
}

