/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.warp;

import java.io.IOException;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.connector.warp.WarpConnector;
import org.apache.catalina.connector.warp.WarpEngine;
import org.apache.catalina.connector.warp.WarpHandler;
import org.apache.catalina.connector.warp.WarpInputStream;
import org.apache.catalina.connector.warp.WarpOutputStream;
import org.apache.catalina.connector.warp.WarpPacket;
import org.apache.catalina.connector.warp.WarpReader;
import org.apache.catalina.connector.warp.WarpRequest;
import org.apache.catalina.connector.warp.WarpResponse;

public class WarpRequestHandler
extends WarpHandler {
    private WarpReader reader = new WarpReader();
    private WarpPacket packet = new WarpPacket();
    private boolean headererr = false;
    protected WarpRequest request = null;
    protected WarpResponse response = null;

    public boolean process(int type, byte[] buffer) {
        WarpConnector connector = this.getConnector();
        WarpEngine engine = (WarpEngine)connector.getContainer();
        String arg1 = null;
        String arg2 = null;
        int valu = -1;
        this.reader.reset(buffer);
        this.packet.reset();
        try {
            switch (type) {
                case 16: {
                    arg1 = this.reader.readString();
                    this.debug("Request Method " + arg1);
                    this.request.setMethod(arg1);
                    break;
                }
                case 17: {
                    arg1 = this.reader.readString();
                    this.debug("Request URI " + arg1);
                    this.request.setRequestURI(arg1);
                    break;
                }
                case 18: {
                    arg1 = this.reader.readString();
                    this.debug("Request Query Argument " + arg1);
                    this.request.setQueryString(arg1);
                    break;
                }
                case 19: {
                    arg1 = this.reader.readString();
                    this.debug("Request Protocol " + arg1);
                    this.request.setProtocol(arg1);
                    break;
                }
                case 20: {
                    arg1 = this.reader.readString();
                    arg2 = this.reader.readString();
                    this.debug("Request Header " + arg1 + ": " + arg2);
                    this.request.addHeader(arg1, arg2);
                    break;
                }
                case 21: {
                    valu = this.reader.readShort();
                    arg1 = this.reader.readString();
                    this.debug("Request Variable [" + valu + "]=" + arg1);
                    break;
                }
                case 29: {
                    this.debug("Invoking request");
                    this.packet.reset();
                    this.send(31, this.packet);
                    WarpInputStream win = new WarpInputStream(this);
                    WarpOutputStream wout = new WarpOutputStream(this, this.response);
                    this.request.setStream(win);
                    this.response.setStream(wout);
                    this.response.setRequest((Request)this.request);
                    try {
                        engine.invoke((Request)this.request, (Response)this.response);
                    }
                    catch (Exception e) {
                        this.log(e);
                    }
                    try {
                        this.response.flushBuffer();
                        this.response.finishResponse();
                        wout.flush();
                        wout.close();
                    }
                    catch (Exception e) {
                        this.debug(e);
                    }
                    this.packet.reset();
                    this.packet.writeString("End of request");
                    this.send(47, this.packet);
                    this.debug("End of request");
                    return false;
                }
                default: {
                    this.log("Wrong packet type " + type);
                    return true;
                }
            }
            return true;
        }
        catch (IOException e) {
            this.log(e);
            return false;
        }
    }
}

