/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.warp;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.connector.HttpResponseBase;
import org.apache.catalina.connector.ResponseBase;
import org.apache.catalina.connector.warp.WarpPacket;
import org.apache.catalina.connector.warp.WarpRequestHandler;
import org.apache.catalina.util.CookieTools;

public class WarpResponse
extends HttpResponseBase {
    private static final boolean DEBUG = false;
    private WarpRequestHandler handler = null;
    private WarpPacket packet = new WarpPacket();
    private boolean committed = false;

    private void debug(Exception exc) {
    }

    private void debug(String msg) {
    }

    protected WarpRequestHandler getWarpRequestHandler() {
        return this.handler;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    protected void sendHeaders() throws IOException {
        ArrayList cookie;
        if (this.isCommitted()) {
            return;
        }
        this.packet.reset();
        String prot = ((ResponseBase)this).request.getRequest().getProtocol();
        this.packet.writeString(prot);
        this.packet.writeShort(this.status);
        if (this.message != null) {
            this.packet.writeString(this.message);
        } else {
            this.packet.writeString("");
        }
        this.handler.send(32, this.packet);
        if (this.getContentType() != null) {
            this.packet.reset();
            this.packet.writeString("Content-Type");
            this.packet.writeString(this.getContentType());
            this.handler.send(33, this.packet);
        }
        if (this.getContentLength() >= 0) {
            this.packet.reset();
            this.packet.writeString("Content-Length");
            this.packet.writeString(Integer.toString(this.getContentLength()));
            this.handler.send(33, this.packet);
        }
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            Iterator names = this.headers.keySet().iterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                ArrayList values = (ArrayList)this.headers.get(name);
                Iterator items = ((AbstractList)values).iterator();
                while (items.hasNext()) {
                    String value = (String)items.next();
                    this.packet.reset();
                    this.packet.writeString(name);
                    this.packet.writeString(value);
                    this.handler.send(33, this.packet);
                }
            }
        }
        HttpServletRequest hreq = (HttpServletRequest)((ResponseBase)this).request.getRequest();
        HttpSession session = hreq.getSession(false);
        if (session != null && session.isNew() && this.getContext().getCookies()) {
            cookie = new Cookie("JSESSIONID", session.getId());
            cookie.setMaxAge(-1);
            String contextPath = null;
            if (((ResponseBase)this).context != null) {
                contextPath = ((ResponseBase)this).context.getPath();
            }
            if (contextPath != null && contextPath.length() > 0) {
                cookie.setPath(contextPath);
            } else {
                cookie.setPath("/");
            }
            if (hreq.isSecure()) {
                cookie.setSecure(true);
            }
            this.addCookie((Cookie)cookie);
        }
        cookie = this.cookies;
        synchronized (cookie) {
            Iterator items = ((AbstractList)this.cookies).iterator();
            while (items.hasNext()) {
                Cookie cookie2 = (Cookie)items.next();
                String name = CookieTools.getCookieHeaderName((Cookie)cookie2);
                String value = CookieTools.getCookieHeaderValue((Cookie)cookie2);
                this.packet.reset();
                this.packet.writeString(name);
                this.packet.writeString(value);
                this.handler.send(33, this.packet);
            }
            // ** MonitorExit[names] (shouldn't be in output)
            this.packet.reset();
            this.handler.send(34, this.packet);
            this.committed = true;
            return;
        }
    }

    protected void setWarpRequestHandler(WarpRequestHandler handler) {
        this.handler = handler;
    }
}

