/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.warp;

public class WarpTable {
    private static int defaultcapacity = 32;
    private int capacity;
    protected int size;
    protected Object[] objects;
    protected int[] ids;

    public WarpTable() {
        this(defaultcapacity);
    }

    public WarpTable(int capacity) {
        if (capacity < defaultcapacity) {
            capacity = defaultcapacity;
        }
        defaultcapacity = capacity;
        this.capacity = capacity;
        this.size = 0;
        this.ids = new int[capacity];
        this.objects = new Object[capacity];
    }

    public boolean add(Object object, int id) throws NullPointerException {
        if (object == null) {
            throw new IllegalArgumentException("Null Object");
        }
        if (id < 0) {
            throw new IllegalArgumentException("ID is less than 0");
        }
        if (this.get(id) != null) {
            return false;
        }
        if (this.capacity == this.size) {
            int newcapacity = this.capacity + defaultcapacity;
            Object[] newobjects = new Object[newcapacity];
            int[] newids = new int[newcapacity];
            System.arraycopy(this.objects, 0, newobjects, 0, this.size);
            System.arraycopy(this.ids, 0, newids, 0, this.size);
            this.capacity = newcapacity;
            this.objects = newobjects;
            this.ids = newids;
        }
        this.objects[this.size] = object;
        this.ids[this.size] = id;
        ++this.size;
        return true;
    }

    public int count() {
        return this.size;
    }

    public Object get(int id) {
        int x = 0;
        while (x < this.size) {
            if (this.ids[x] == id) {
                return this.objects[x];
            }
            ++x;
        }
        return null;
    }

    public Object remove(int id) {
        int x = 0;
        while (x < this.size) {
            if (this.ids[x] == id) {
                Object oldobject = this.objects[x];
                --this.size;
                this.objects[x] = this.objects[this.size];
                this.ids[x] = this.ids[this.size];
                if (this.capacity - this.size > defaultcapacity << 1) {
                    int newcapacity = this.capacity - defaultcapacity;
                    Object[] newobjects = new Object[newcapacity];
                    int[] newids = new int[newcapacity];
                    System.arraycopy(this.objects, 0, newobjects, 0, this.size);
                    System.arraycopy(this.ids, 0, newids, 0, this.size);
                    this.capacity = newcapacity;
                    this.objects = newobjects;
                    this.ids = newids;
                }
                return oldobject;
            }
            ++x;
        }
        return null;
    }
}

