/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import org.apache.jasper.logging.Logger;
import org.apache.jasper.runtime.BodyContentImpl;
import org.apache.jasper.runtime.JspWriterImpl;
import org.apache.jasper.runtime.ServletResponseWrapperInclude;

public class PageContextImpl
extends PageContext {
    Logger.Helper loghelper = new Logger.Helper("JASPER_LOG", "PageContextImpl");
    Stack writerStack = new Stack();
    protected Servlet servlet;
    protected ServletConfig config;
    protected ServletContext context;
    protected JspFactory factory;
    protected boolean needsSession;
    protected String errorPageURL;
    protected boolean autoFlush;
    protected int bufferSize;
    protected transient Hashtable attributes = new Hashtable(16);
    protected transient ServletRequest request;
    protected transient ServletResponse response;
    protected transient Object page;
    protected transient HttpSession session;
    protected boolean isIncluded;
    protected transient JspWriter out;

    PageContextImpl(JspFactory factory) {
        this.factory = factory;
    }

    protected JspWriter _createOut(int bufferSize, boolean autoFlush) throws IOException, IllegalArgumentException {
        try {
            return new JspWriterImpl(this.response, bufferSize, autoFlush);
        }
        catch (Throwable t) {
            this.loghelper.log("creating out", t);
            return null;
        }
    }

    void _initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) throws IOException, IllegalStateException, IllegalArgumentException {
        this.servlet = servlet;
        this.config = servlet.getServletConfig();
        this.context = this.config.getServletContext();
        this.needsSession = needsSession;
        this.errorPageURL = errorPageURL;
        this.bufferSize = bufferSize;
        this.autoFlush = autoFlush;
        this.request = request;
        this.response = response;
        if (request instanceof HttpServletRequest && needsSession) {
            this.session = ((HttpServletRequest)request).getSession();
        }
        if (needsSession && this.session == null) {
            throw new IllegalStateException("Page needs a session and none is available");
        }
        if (this.out == null) {
            this.out = this._createOut(bufferSize, autoFlush);
        } else {
            ((JspWriterImpl)this.out).init(response, bufferSize, autoFlush);
        }
        if (this.out == null) {
            throw new IllegalStateException("failed initialize JspWriter");
        }
        this.setAttribute("javax.servlet.jsp.jspOut", this.out);
        this.setAttribute("javax.servlet.jsp.jspRequest", request);
        this.setAttribute("javax.servlet.jsp.jspResponse", response);
        if (this.session != null) {
            this.setAttribute("javax.servlet.jsp.jspSession", this.session);
        }
        this.setAttribute("javax.servlet.jsp.jspPage", servlet);
        this.setAttribute("javax.servlet.jsp.jspConfig", this.config);
        this.setAttribute("javax.servlet.jsp.jspPageContext", (Object)this);
        this.setAttribute("javax.servlet.jsp.jspApplication", this.context);
        this.isIncluded = request.getAttribute("javax.servlet.include.servlet_path") != null;
    }

    public Object findAttribute(String name) {
        Object o = this.attributes.get(name);
        if (o != null) {
            return o;
        }
        o = this.request.getAttribute(name);
        if (o != null) {
            return o;
        }
        if (this.session != null && (o = this.session.getAttribute(name)) != null) {
            return o;
        }
        return this.context.getAttribute(name);
    }

    public void forward(String relativeUrlPath) throws ServletException, IOException {
        String path = this.getAbsolutePathRelativeToContext(relativeUrlPath);
        this.context.getRequestDispatcher(path).forward(this.request, this.response);
    }

    private final String getAbsolutePathRelativeToContext(String relativeUrlPath) {
        String path = relativeUrlPath;
        if (!path.startsWith("/")) {
            String uri = (String)this.request.getAttribute("javax.servlet.include.servlet_path");
            if (uri == null) {
                uri = ((HttpServletRequest)this.request).getServletPath();
            }
            String baseURI = uri.substring(0, uri.lastIndexOf(47));
            path = String.valueOf(baseURI) + '/' + path;
        }
        return path;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Object getAttribute(String name, int scope) {
        switch (scope) {
            case 1: {
                return this.attributes.get(name);
            }
            case 2: {
                return this.request.getAttribute(name);
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalArgumentException("can't access SESSION_SCOPE without an HttpSession");
                }
                return this.session.getAttribute(name);
            }
            case 4: {
                return this.context.getAttribute(name);
            }
        }
        throw new IllegalArgumentException("unidentified scope");
    }

    public Enumeration getAttributeNamesInScope(int scope) {
        switch (scope) {
            case 1: {
                return this.attributes.keys();
            }
            case 2: {
                return this.request.getAttributeNames();
            }
            case 3: {
                if (this.session != null) {
                    return this.session.getAttributeNames();
                }
                throw new IllegalArgumentException("can't access SESSION_SCOPE without an HttpSession");
            }
            case 4: {
                return this.context.getAttributeNames();
            }
        }
        return new Enumeration(){

            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() {
                throw new NoSuchElementException();
            }
        };
    }

    public int getAttributesScope(String name) {
        if (this.attributes.get(name) != null) {
            return 1;
        }
        if (this.request.getAttribute(name) != null) {
            return 2;
        }
        if (this.session != null && this.session.getAttribute(name) != null) {
            return 3;
        }
        if (this.context.getAttribute(name) != null) {
            return 4;
        }
        return 0;
    }

    public Exception getException() {
        return (Exception)this.request.getAttribute("javax.servlet.jsp.jspException");
    }

    public JspWriter getOut() {
        return this.out;
    }

    public Object getPage() {
        return this.servlet;
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public ServletContext getServletContext() {
        return this.config.getServletContext();
    }

    public HttpSession getSession() {
        return this.session;
    }

    public void handlePageException(Exception ex) throws IOException, ServletException {
        this.handlePageException((Throwable)ex);
    }

    public void handlePageException(Throwable t) throws IOException, ServletException {
        this.request.setAttribute("javax.servlet.jsp.jspException", (Object)t);
        if (this.errorPageURL != null && !this.errorPageURL.equals("")) {
            try {
                this.forward(this.errorPageURL);
            }
            catch (IllegalStateException illegalStateException) {
                this.include(this.errorPageURL);
            }
        } else {
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new ServletException(t);
        }
    }

    public void include(String relativeUrlPath) throws ServletException, IOException {
        String path = this.getAbsolutePathRelativeToContext(relativeUrlPath);
        this.context.getRequestDispatcher(path).include(this.request, (ServletResponse)new ServletResponseWrapperInclude(this.response, this.out));
    }

    public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) throws IOException, IllegalStateException, IllegalArgumentException {
        this._initialize(servlet, request, response, errorPageURL, needsSession, bufferSize, autoFlush);
    }

    public JspWriter popBody() {
        this.out = (JspWriter)this.writerStack.pop();
        return this.out;
    }

    public BodyContent pushBody() {
        JspWriter previous = this.out;
        this.writerStack.push(this.out);
        this.out = new BodyContentImpl(previous);
        return (BodyContent)this.out;
    }

    public void release() {
        try {
            if (this.isIncluded) {
                ((JspWriterImpl)this.out).flushBuffer();
            } else {
                this.out.flush();
            }
        }
        catch (IOException iOException) {
            this.loghelper.log("Internal error flushing the buffer in release()");
        }
        this.servlet = null;
        this.config = null;
        this.context = null;
        this.needsSession = false;
        this.errorPageURL = null;
        this.bufferSize = -1;
        this.autoFlush = true;
        this.request = null;
        this.response = null;
        this.out = null;
        if (this.out instanceof JspWriterImpl) {
            ((JspWriterImpl)this.out).recycle();
        }
        this.session = null;
        this.attributes.clear();
    }

    public void removeAttribute(String name) {
        try {
            this.removeAttribute(name, 1);
            this.removeAttribute(name, 2);
            this.removeAttribute(name, 3);
            this.removeAttribute(name, 4);
        }
        catch (Exception exception) {}
    }

    public void removeAttribute(String name, int scope) {
        switch (scope) {
            case 1: {
                this.attributes.remove(name);
                break;
            }
            case 2: {
                this.request.removeAttribute(name);
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalArgumentException("can't access SESSION_SCOPE without an HttpSession");
                }
                this.session.removeAttribute(name);
                break;
            }
            case 4: {
                this.context.removeAttribute(name);
                break;
            }
        }
    }

    public void setAttribute(String name, Object attribute) {
        this.attributes.put(name, attribute);
    }

    public void setAttribute(String name, Object o, int scope) {
        switch (scope) {
            case 1: {
                this.attributes.put(name, o);
                break;
            }
            case 2: {
                this.request.setAttribute(name, o);
                break;
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalArgumentException("can't access SESSION_SCOPE without an HttpSession");
                }
                this.session.setAttribute(name, o);
                break;
            }
            case 4: {
                this.context.setAttribute(name, o);
                break;
            }
        }
    }
}

