/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.JavaCompiler;
import org.apache.jasper.compiler.JspParseEventListener;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.Mangler;
import org.apache.jasper.compiler.ParseEventListener;
import org.apache.jasper.compiler.ParseException;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.compiler.ServletWriter;
import org.xml.sax.Attributes;

public class Compiler {
    protected JavaCompiler javac;
    protected Mangler mangler;
    protected JspCompilationContext ctxt;

    public Compiler(JspCompilationContext ctxt) {
        this.ctxt = ctxt;
    }

    public String changeEncodingIfNecessary(JspReader tmpReader) throws ParseException {
        while (tmpReader.skipUntil("<%@") != null) {
            tmpReader.skipSpaces();
            if (!tmpReader.matches("page")) continue;
            tmpReader.advance(4);
            tmpReader.skipSpaces();
            try {
                int loc;
                Attributes attrs = tmpReader.parseTagAttributes();
                String ct = attrs.getValue("contentType");
                if (ct == null || (loc = ct.indexOf("charset=")) <= 0) continue;
                String encoding = ct.substring(loc + 8);
                return encoding;
            }
            catch (ParseException parseException) {
                return null;
            }
        }
        return null;
    }

    public boolean compile() throws FileNotFoundException, JasperException, Exception {
        OutputStreamWriter osw;
        String classFileName = this.mangler.getClassFileName();
        String className = this.mangler.getClassName();
        this.ctxt.setServletClassName(className);
        Constants.message((String)"jsp.message.class_name_is", (Object[])new Object[]{className}, (int)4);
        if (!this.isOutDated()) {
            return false;
        }
        String javaFileName = this.mangler.getJavaFileName();
        this.ctxt.setServletJavaFileName(javaFileName);
        Constants.message((String)"jsp.message.java_file_name_is", (Object[])new Object[]{javaFileName}, (int)4);
        String javaEncoding = "UTF8";
        try {
            osw = new OutputStreamWriter((OutputStream)new FileOutputStream(javaFileName), javaEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            javaEncoding = this.ctxt.getOptions().getJavaEncoding();
            if (javaEncoding != null) {
                try {
                    osw = new OutputStreamWriter((OutputStream)new FileOutputStream(javaFileName), javaEncoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    throw new JasperException(Constants.getString((String)"jsp.error.invalid.javaEncoding", (Object[])new Object[]{"UTF8", javaEncoding}));
                }
            }
            throw new JasperException(Constants.getString((String)"jsp.error.needAlternateJavaEncoding", (Object[])new Object[]{"UTF8"}));
        }
        ServletWriter writer = new ServletWriter(new PrintWriter(osw));
        this.ctxt.setWriter(writer);
        ParserController parserCtl = new ParserController(this.ctxt);
        parserCtl.parse(this.ctxt.getJspFile());
        ParseEventListener listener = parserCtl.getParseEventListener();
        listener.beginPageProcessing();
        listener.endPageProcessing();
        writer.close();
        ((JspParseEventListener)listener).validate();
        String classpath = this.ctxt.getClassPath();
        String sep = System.getProperty("path.separator");
        String[] argv = new String[]{"-encoding", javaEncoding, "-classpath", String.valueOf(System.getProperty("java.class.path")) + sep + classpath, "-d", this.ctxt.getOutputDir(), javaFileName};
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < argv.length) {
            b.append(argv[i]);
            b.append(" ");
            ++i;
        }
        Constants.message((String)"jsp.message.compiling_with", (Object[])new Object[]{b.toString()}, (int)4);
        ByteArrayOutputStream out = new ByteArrayOutputStream(256);
        if (this.javac == null) {
            return true;
        }
        this.javac.setEncoding(javaEncoding);
        this.javac.setClasspath(String.valueOf(System.getProperty("java.class.path")) + sep + classpath);
        this.javac.setOutputDir(this.ctxt.getJavacOutputDir());
        this.javac.setMsgOutput(out);
        boolean status = this.javac.compile(javaFileName);
        if (!this.ctxt.keepGenerated()) {
            File javaFile = new File(javaFileName);
            javaFile.delete();
        }
        if (!status) {
            String msg = out.toString();
            throw new JasperException(String.valueOf(Constants.getString((String)"jsp.error.unable.compile")) + msg);
        }
        return true;
    }

    public boolean isOutDated() {
        return true;
    }

    public void removeGeneratedFiles() {
        try {
            String classFileName = this.mangler.getClassFileName();
            if (classFileName != null) {
                File classFile = new File(classFileName);
                classFile.delete();
            }
        }
        catch (Exception exception) {}
    }

    public void setJavaCompiler(JavaCompiler javac) {
        this.javac = javac;
    }

    public void setMangler(Mangler mangler) {
        this.mangler = mangler;
    }
}

