/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.CompileException;
import org.apache.jasper.compiler.GeneratorBase;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ServiceMethodPhase;
import org.apache.jasper.compiler.ServletWriter;
import org.xml.sax.Attributes;

public class IncludeGenerator
extends GeneratorBase
implements ServiceMethodPhase {
    String page;
    boolean isExpression = false;
    boolean flush;
    Hashtable params;
    boolean isXml;

    public IncludeGenerator(Mark start, Attributes attrs, Hashtable param, boolean isXml) throws JasperException {
        if (attrs.getLength() > 2) {
            throw new CompileException(start, Constants.getString((String)"jsp.error.include.tag"));
        }
        this.page = attrs.getValue("page");
        if (this.page == null) {
            throw new CompileException(start, Constants.getString((String)"jsp.error.include.tag"));
        }
        String flushString = attrs.getValue("flush");
        if (flushString == null && attrs.getLength() != 1) {
            throw new CompileException(start, Constants.getString((String)"jsp.error.include.tag"));
        }
        if (flushString == null || flushString.equalsIgnoreCase("false")) {
            this.flush = false;
        } else if (flushString.equalsIgnoreCase("true")) {
            this.flush = true;
        } else {
            throw new CompileException(start, Constants.getString((String)"jsp.error.include.flush.invalid.value", (Object[])new Object[]{flushString}));
        }
        this.params = param;
        this.isXml = isXml;
        this.isExpression = JspUtil.isExpression(this.page, isXml);
    }

    public void generate(ServletWriter writer, Class phase) {
        boolean initial = true;
        String sep = "?";
        writer.println("{");
        writer.pushIndent();
        writer.println("String _jspx_qStr = \"\";");
        if (this.flush) {
            writer.println("out.flush();");
        }
        if (this.params != null && this.params.size() > 0) {
            Enumeration en = this.params.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String[] value = (String[])this.params.get(key);
                if (initial) {
                    sep = "?";
                    initial = false;
                } else {
                    sep = "&";
                }
                if (value.length == 1 && JspUtil.isExpression(value[0], this.isXml)) {
                    writer.println("_jspx_qStr = _jspx_qStr + \"" + sep + key + "=\" + " + JspUtil.getExpr(value[0], this.isXml) + ";");
                    continue;
                }
                if (value.length == 1) {
                    writer.println("_jspx_qStr = _jspx_qStr + \"" + sep + key + "=\" + \"" + value[0] + "\";");
                    continue;
                }
                int i = 0;
                while (i < value.length) {
                    if (!JspUtil.isExpression(value[i], this.isXml)) {
                        writer.println("_jspx_qStr = _jspx_qStr + \"" + sep + key + "=\" + \"" + value[i] + "\";");
                    } else {
                        writer.println("_jspx_qStr = _jspx_qStr + \"" + sep + key + "=\" +" + JspUtil.getExpr(value[i], this.isXml) + ";");
                    }
                    if (sep.equals("?")) {
                        sep = "&";
                    }
                    ++i;
                }
            }
        }
        if (!this.isExpression) {
            writer.println("pageContext.include(" + writer.quoteString(this.page) + " + _jspx_qStr);");
        } else {
            writer.println("pageContext.include(" + JspUtil.getExpr(this.page, this.isXml) + " + _jspx_qStr);");
        }
        writer.popIndent();
        writer.println("}");
    }
}

