/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.net.URL;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.Mangler;
import org.apache.jasper.logging.Logger;

public class JspCompiler
extends Compiler
implements Mangler {
    String javaFileName;
    String classFileName;
    String realClassName;
    File jsp;
    String outputDir;
    boolean outDated;
    Logger.Helper loghelper = new Logger.Helper("JASPER_LOG", "JspCompiler");

    public JspCompiler(JspCompilationContext ctxt) throws JasperException {
        super(ctxt);
        this.jsp = new File(ctxt.getJspFile());
        this.outputDir = ctxt.getOutputDir();
        this.outDated = false;
        this.setMangler(this);
    }

    private final String getBaseClassName() {
        String className = this.jsp.getName().endsWith(".jsp") ? this.jsp.getName().substring(0, this.jsp.getName().length() - 4) : this.jsp.getName();
        StringBuffer modifiedClassName = new StringBuffer();
        int i = 0;
        while (i < className.length()) {
            if (Character.isLetterOrDigit(className.charAt(i))) {
                modifiedClassName.append(className.substring(i, i + 1));
            } else {
                modifiedClassName.append(JspCompiler.mangleChar(className.charAt(i)));
            }
            ++i;
        }
        modifiedClassName.append("_jsp");
        return modifiedClassName.toString();
    }

    public final String getClassFileName() {
        if (this.classFileName != null) {
            return this.classFileName;
        }
        this.classFileName = String.valueOf(this.getClassName()) + ".class";
        if (this.outputDir != null && !this.outputDir.equals("")) {
            this.classFileName = String.valueOf(this.outputDir) + File.separatorChar + this.classFileName;
        }
        return this.classFileName;
    }

    public final String getClassName() {
        if (this.realClassName == null) {
            this.realClassName = this.getBaseClassName();
        }
        return this.realClassName;
    }

    public final String getJavaFileName() {
        if (this.javaFileName != null) {
            return this.javaFileName;
        }
        this.javaFileName = String.valueOf(this.getClassName()) + ".java";
        if (this.outputDir != null && !this.outputDir.equals("")) {
            this.javaFileName = String.valueOf(this.outputDir) + File.separatorChar + this.javaFileName;
        }
        return this.javaFileName;
    }

    public boolean isOutDated() {
        long jspRealLastModified = 0L;
        try {
            URL jspUrl = this.ctxt.getResource(this.jsp.getPath());
            if (jspUrl == null) {
                return true;
            }
            jspRealLastModified = jspUrl.openConnection().getLastModified();
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
        File classFile = new File(this.getClassFileName());
        this.outDated = classFile.exists() ? classFile.lastModified() < jspRealLastModified : true;
        return this.outDated;
    }

    private static final String mangleChar(char ch) {
        if (ch == File.separatorChar) {
            ch = (char)47;
        }
        String s = Integer.toHexString(ch);
        int nzeros = 5 - s.length();
        char[] result = new char[6];
        result[0] = 95;
        int i = 1;
        while (i <= nzeros) {
            result[i] = 48;
            ++i;
        }
        int i2 = nzeros + 1;
        int j = 0;
        while (i2 < 6) {
            result[i2] = s.charAt(j);
            ++i2;
            ++j;
        }
        return new String(result);
    }
}

