/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Stack;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.JspParseEventListener;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ParseEventListener;
import org.apache.jasper.compiler.Parser;
import org.apache.jasper.compiler.ParserXJspSax;
import org.xml.sax.Attributes;

public class ParserController {
    private JspCompilationContext ctxt;
    private Stack baseDirStack = new Stack();
    private ParseEventListener jspHandler = null;
    private boolean isXml;
    private static final String JSP_ROOT_TAG = "<jsp:root";
    private boolean isTopFile = true;
    private String topFileEncoding = "ISO-8859-1";
    private String newEncoding;

    public ParserController(JspCompilationContext ctxt) {
        this.ctxt = ctxt;
        this.jspHandler = new JspParseEventListener(ctxt, this);
    }

    private void figureOutJspDocument(File file, String encoding, InputStreamReader reader) throws JasperException {
        JspReader jspReader;
        try {
            jspReader = new JspReader(this.ctxt, file, encoding, reader);
        }
        catch (FileNotFoundException ex) {
            throw new JasperException((Throwable)ex);
        }
        jspReader.setSingleFile(true);
        Mark startMark = jspReader.mark();
        jspReader.reset(startMark);
        Mark mark = jspReader.skipUntil(JSP_ROOT_TAG);
        this.isXml = mark != null;
        this.newEncoding = null;
        if (!this.isXml) {
            jspReader.reset(startMark);
            while (jspReader.skipUntil("<%@") != null) {
                jspReader.skipSpaces();
                if (!jspReader.matches("page")) continue;
                jspReader.advance(4);
                jspReader.skipSpaces();
                Attributes attrs = jspReader.parseTagAttributes();
                String attribute = "pageEncoding";
                this.newEncoding = attrs.getValue("pageEncoding");
                if (this.newEncoding == null) {
                    int loc;
                    String contentType = attrs.getValue("contentType");
                    if (contentType == null || (loc = contentType.indexOf("charset=")) == -1) continue;
                    this.newEncoding = contentType.substring(loc + 8);
                    return;
                }
                return;
            }
        }
    }

    public ParseEventListener getParseEventListener() {
        return this.jspHandler;
    }

    private InputStreamReader getReader(File file, String encoding, String absFileName) throws FileNotFoundException, JasperException {
        try {
            InputStreamReader reader;
            if (this.ctxt == null) {
                FileInputStream in = new FileInputStream(file);
                reader = new InputStreamReader((InputStream)in, encoding);
            } else {
                InputStream in = this.ctxt.getResourceAsStream(file.toString());
                if (in == null) {
                    throw new FileNotFoundException(absFileName);
                }
                reader = new InputStreamReader(in, encoding);
            }
            return reader;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new JasperException(Constants.getString((String)"jsp.error.unsupported.encoding", (Object[])new Object[]{encoding}));
        }
    }

    private void p(String s) {
        System.out.println("[ParserController] " + s);
    }

    private void p(String s, Throwable ex) {
        this.p(s);
        this.p(ex.getMessage());
        ex.printStackTrace();
    }

    public void parse(String inFileName) throws FileNotFoundException, JasperException {
        String filePath;
        String absFileName = this.resolveFileName(inFileName);
        File file = new File(absFileName);
        String string = filePath = this.ctxt == null ? file.getAbsolutePath() : this.ctxt.getRealPath(file.toString());
        if (filePath == null) {
            filePath = file.toString();
        }
        String encoding = this.topFileEncoding;
        InputStreamReader reader = null;
        try {
            reader = this.getReader(file, encoding, absFileName);
            this.figureOutJspDocument(file, encoding, reader);
            String string2 = encoding = this.newEncoding != null ? this.newEncoding : encoding;
            if (this.isTopFile) {
                this.topFileEncoding = encoding;
                this.isTopFile = false;
            }
            try {
                reader.close();
            }
            catch (IOException iOException) {}
            reader = this.getReader(file, encoding, absFileName);
            if (this.isXml) {
                new ParserXJspSax(filePath, reader, this.jspHandler).parse();
            } else {
                new Parser(this.ctxt, file, encoding, reader, this.jspHandler).parse();
            }
            this.baseDirStack.pop();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        Object var8_7 = null;
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    private String resolveFileName(String inFileName) {
        File file = new File(inFileName);
        boolean isAbsolute = file.getPath().startsWith(File.separator);
        String fileName = isAbsolute ? inFileName : String.valueOf((String)this.baseDirStack.peek()) + inFileName;
        String baseDir = inFileName.substring(0, file.getPath().lastIndexOf(File.separator) + 1);
        this.baseDirStack.push(baseDir);
        return fileName;
    }
}

