/* ========================================================================= *
 *                                                                           *
 *                 The Apache Software License,  Version 1.1                 *
 *                                                                           *
 *         Copyright (c) 1999, 2000  The Apache Software Foundation.         *
 *                           All rights reserved.                            *
 *                                                                           *
 * ========================================================================= *
 *                                                                           *
 * Redistribution and use in source and binary forms,  with or without modi- *
 * fication, are permitted provided that the following conditions are met:   *
 *                                                                           *
 * 1. Redistributions of source code  must retain the above copyright notice *
 *    notice, this list of conditions and the following disclaimer.          *
 *                                                                           *
 * 2. Redistributions  in binary  form  must  reproduce the  above copyright *
 *    notice,  this list of conditions  and the following  disclaimer in the *
 *    documentation and/or other materials provided with the distribution.   *
 *                                                                           *
 * 3. The end-user documentation  included with the redistribution,  if any, *
 *    must include the following acknowlegement:                             *
 *                                                                           *
 *       "This product includes  software developed  by the Apache  Software *
 *        Foundation <http://www.apache.org/>."                              *
 *                                                                           *
 *    Alternately, this acknowlegement may appear in the software itself, if *
 *    and wherever such third-party acknowlegements normally appear.         *
 *                                                                           *
 * 4. The names  "The  Jakarta  Project",  "Tomcat",  and  "Apache  Software *
 *    Foundation"  must not be used  to endorse or promote  products derived *
 *    from this  software without  prior  written  permission.  For  written *
 *    permission, please contact <apache@apache.org>.                        *
 *                                                                           *
 * 5. Products derived from this software may not be called "Apache" nor may *
 *    "Apache" appear in their names without prior written permission of the *
 *    Apache Software Foundation.                                            *
 *                                                                           *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES *
 * INCLUDING, BUT NOT LIMITED TO,  THE IMPLIED WARRANTIES OF MERCHANTABILITY *
 * AND FITNESS FOR  A PARTICULAR PURPOSE  ARE DISCLAIMED.  IN NO EVENT SHALL *
 * THE APACHE  SOFTWARE  FOUNDATION OR  ITS CONTRIBUTORS  BE LIABLE  FOR ANY *
 * DIRECT,  INDIRECT,   INCIDENTAL,  SPECIAL,  EXEMPLARY,  OR  CONSEQUENTIAL *
 * DAMAGES (INCLUDING,  BUT NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE GOODS *
 * OR SERVICES;  LOSS OF USE,  DATA,  OR PROFITS;  OR BUSINESS INTERRUPTION) *
 * HOWEVER CAUSED AND  ON ANY  THEORY  OF  LIABILITY,  WHETHER IN  CONTRACT, *
 * STRICT LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN *
 * ANY  WAY  OUT OF  THE  USE OF  THIS  SOFTWARE,  EVEN  IF  ADVISED  OF THE *
 * POSSIBILITY OF SUCH DAMAGE.                                               *
 *                                                                           *
 * ========================================================================= *
 *                                                                           *
 * This software  consists of voluntary  contributions made  by many indivi- *
 * duals on behalf of the  Apache Software Foundation.  For more information *
 * on the Apache Software Foundation, please see <http://www.apache.org/>.   *
 *                                                                           *
 * ========================================================================= */
package org.apache.catalina.connector.warp;

import javax.servlet.ServletException;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import java.io.IOException;
import java.net.URL;
import org.apache.catalina.Container;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.HostConfig;
import org.apache.catalina.LifecycleException;

/**
 *
 *
 * @author <a href="mailto:pier.fumagalli@eng.sun.com">Pier Fumagalli</a>
 * @author Copyright &copy; 1999, 2000 <a href="http://www.apache.org">The
 *         Apache Software Foundation.
 * @version CVS $Id: WarpHost.java,v 1.7 2001/01/24 23:10:48 pier Exp $
 */
public class WarpHost extends StandardHost {

    // -------------------------------------------------------------- CONSTANTS

    /** Our debug flag status (Used to compile out debugging information). */
    private static final boolean DEBUG=WarpDebug.DEBUG;
    /** The class used for contexts. */
    private static String cc="org.apache.catalina.connector.warp.WarpContext";

    // -------------------------------------------------------- LOCAL VARIABLES

    /** The Warp Host ID of this Host. */
    private int id=-1;
    /** The ID to use for the next dynamically configured application. */
    private int applid=0;

    /**
     * Create a new instance of a WarpHost.
     */
    public WarpHost() {
        super();
        HostConfig conf=new HostConfig();
        conf.setContextClass(cc);
        this.setContextClass(cc);
        this.addLifecycleListener(conf);
        this.setDebug(9);
    }

    // --------------------------------------------------------- PUBLIC METHODS

    public void invoke(Request req, Response res)
    throws ServletException, IOException {
        if (DEBUG) this.debug("Invoked");
        super.invoke(req,res);
    }

    public Container map(Request request, boolean update) {
        if (DEBUG) this.debug("Trying to map request to context");
        if (request instanceof WarpRequest) {
            WarpRequest r=(WarpRequest)request;

    	    Container children[]=this.findChildren();
    	    for (int x=0; x<children.length; x++) {
    	        if (children[x] instanceof WarpContext) {
    	            WarpContext c=(WarpContext)children[x];
    	            if (r.getRequestedApplicationID()==c.getApplicationID()) {
    	                ((WarpRequest)request).setContextPath(c.getPath());
    	                return(children[x]);
    	            }
                }
            }
        }
        if (DEBUG) this.debug("Trying to map request to context (std)");
        return(super.map(request,update));
    }

    /**
     * Add a new context to this host.
     */
    public void addChild(Container container) {
        if (container instanceof WarpContext) {
            WarpContext cont=(WarpContext)container;
            cont.setApplicationID(this.applid++);
            if (DEBUG) this.debug("Adding context for path \""+cont.getName()+
                                  "\" with ID="+cont.getApplicationID());
            super.addChild(cont);
        } else {
            throw new IllegalArgumentException("Cannot add context class "+
                             container.getClass().getName()+" to WarpContext");
        }
    }

    // ----------------------------------------------------------- BEAN METHODS

    /**
     * Return the Host ID associated with this WarpHost instance.
     */
    protected int getHostID() {
        return(this.id);
    }

    /**
     * Set the Host ID associated with this WarpHost instance.
     */
    protected void setHostID(int id) {
        if (DEBUG) this.debug("Setting HostID for "+super.getName()+" to "+id);
        this.id=id;
    }

    // ------------------------------------------------------ DEBUGGING METHODS

    /**
     * Dump a debug message.
     */
    private void debug(String msg) {
        if (DEBUG) WarpDebug.debug(this,msg);
    }

    /**
     * Dump information for an Exception.
     */
    private void debug(Exception exc) {
        if (DEBUG) WarpDebug.debug(this,exc);
    }
}
