/*
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Tomcat", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.tools.ant.types;

import org.apache.tools.ant.BuildException;

import junit.framework.TestCase;
import junit.framework.AssertionFailedError;

/**
 * JUnit 3 testcases for org.apache.tools.ant.EnumeratedAttribute.
 *
 * @author Stefan Bodewig <a href="mailto:stefan.bodewig@megabit.net">stefan.bodewig@megabit.net</a> 
 */

public class EnumeratedAttributeTest extends TestCase {

    private static String[] expected = {"a", "b", "c"};

    public EnumeratedAttributeTest(String name) {
        super(name);
    }
    
    public void testContains() {
        EnumeratedAttribute t1 = new TestNormal();
        for (int i=0; i<expected.length; i++) {
            assert(expected[i]+" is in TestNormal",
                   t1.containsValue(expected[i]));
            assert(expected[i].toUpperCase()+" is in TestNormal",
                   !t1.containsValue(expected[i].toUpperCase()));
        }
        assert("TestNormal doesn\'t have \"d\" attribute",
               !t1.containsValue("d"));
        assert("TestNull doesn\'t have \"d\" attribute and doesn\'t die",
               !(new TestNull()).containsValue("d"));
    }

    public void testExceptions() {
        EnumeratedAttribute t1 = new TestNormal();
        for (int i=0; i<expected.length; i++) {
            try {
                t1.setValue(expected[i]);
            } catch (BuildException be) {
                fail("unexpected exception for value "+expected[i]);
            }
        }
        try {
            t1.setValue("d");
            fail("expected exception for value \"d\"");
        } catch (BuildException be) {
        }
        try {
            (new TestNull()).setValue("d");
            fail("expected exception for value \"d\" in TestNull");
        } catch (BuildException be) {
        } catch (Throwable other) {
            fail("unexpected death of TestNull: "+other.getMessage());
        }
    }

    public static class TestNormal extends EnumeratedAttribute {
        public String[] getValues() {
            return expected;
        }
    }

    public static class TestNull extends EnumeratedAttribute {
        public String[] getValues() {
            return null;
        }
    }
}
