/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.PathTokenizer;

public class Path {
    private Vector definition = new Vector();
    public static Path systemClasspath = new Path(System.getProperty("java.class.path"));

    public Path() {
    }

    public Path(String path) {
        this();
        this.setPath(path);
    }

    public void append(Path other) {
        String[] l = other.list();
        int i = 0;
        while (i < l.length) {
            if (this.definition.indexOf(l[i]) == -1) {
                this.definition.addElement(l[i]);
            }
            ++i;
        }
    }

    public Path createPathElement() {
        return this;
    }

    public String[] list() {
        Object[] result = new String[this.definition.size()];
        this.definition.copyInto(result);
        return result;
    }

    public void setLocation(String location) {
        String element;
        if (location != null && location.length() > 0 && this.definition.indexOf(element = Path.translateFile(location)) == -1) {
            this.definition.addElement(element);
        }
    }

    public void setPath(String path) {
        Vector elements = Path.translatePath(path);
        int i = 0;
        while (i < elements.size()) {
            String element = (String)elements.elementAt(i);
            if (this.definition.indexOf(element) == -1) {
                this.definition.addElement(element);
            }
            ++i;
        }
    }

    public String toString() {
        String[] list = this.list();
        if (list.length == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer(list[0].toString());
        int i = 1;
        while (i < list.length) {
            result.append(File.pathSeparatorChar);
            result.append(list[i]);
            ++i;
        }
        return result.toString();
    }

    public static String translateFile(String source) {
        if (source == null) {
            return "";
        }
        StringBuffer result = new StringBuffer(source);
        int i = 0;
        while (i < result.length()) {
            Path.translateFileSep(result, i);
            ++i;
        }
        return result.toString();
    }

    protected static boolean translateFileSep(StringBuffer buffer, int pos) {
        if (buffer.charAt(pos) == '/' || buffer.charAt(pos) == '\\') {
            buffer.setCharAt(pos, File.separatorChar);
            return true;
        }
        return false;
    }

    public static Vector translatePath(String source) {
        Vector<String> result = new Vector<String>();
        if (source == null) {
            return result;
        }
        PathTokenizer tok = new PathTokenizer(source);
        StringBuffer element = new StringBuffer();
        while (tok.hasMoreTokens()) {
            element.setLength(0);
            element.append(tok.nextToken());
            int i = 0;
            while (i < element.length()) {
                Path.translateFileSep(element, i);
                ++i;
            }
            result.addElement(element.toString());
        }
        return result;
    }
}

