/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Path;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Jikes;
import org.apache.tools.ant.taskdefs.JikesOutputParser;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.TaskOutputStream;
import sun.tools.javac.Main;

public class Javac
extends MatchingTask {
    private static final int MODERN_COMPILER_SUCCESS = 0;
    private Path src;
    private File destDir;
    private Path compileClasspath;
    private boolean debug = false;
    private boolean optimize = false;
    private boolean deprecation = false;
    private boolean filtering = false;
    private String target;
    private Path bootclasspath;
    private Path extdirs;
    protected Vector compileList = new Vector();
    protected Hashtable filecopyList = new Hashtable();

    private void addExistingToClasspath(Path target, Path source) {
        String[] list = source.list();
        int i = 0;
        while (i < list.length) {
            File f = this.project.resolveFile(list[i]);
            if (f.exists()) {
                target.setLocation(f.getAbsolutePath());
            } else {
                this.log("Dropping from classpath: " + f.getAbsolutePath(), 3);
            }
            ++i;
        }
    }

    private void addExtdirsToClasspath(Path classpath) {
        if (this.extdirs != null) {
            String[] list = this.extdirs.list();
            int j = 0;
            while (j < list.length) {
                File dir = this.project.resolveFile(list[j]);
                String[] files = dir.list(new JarFilenameFilter());
                int i = 0;
                while (i < files.length) {
                    File f = new File(dir, files[i]);
                    if (f.exists() && f.isFile()) {
                        classpath.setLocation(f.getAbsolutePath());
                    }
                    ++i;
                }
                ++j;
            }
        }
    }

    public Path createBootclasspath() {
        if (this.bootclasspath == null) {
            this.bootclasspath = new Path();
        }
        return this.bootclasspath;
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path();
        }
        return this.compileClasspath;
    }

    public Path createExtdirs() {
        if (this.extdirs == null) {
            this.extdirs = new Path();
        }
        return this.extdirs;
    }

    public Path createSrc() {
        if (this.src != null) {
            this.src = new Path();
        }
        return this.src;
    }

    private void doClassicCompile() throws BuildException {
        this.log("Using classic compiler", 3);
        Path classpath = this.getCompileClasspath(false);
        Vector<String> argList = new Vector<String>();
        if (this.deprecation) {
            argList.addElement("-deprecation");
        }
        argList.addElement("-d");
        argList.addElement(this.destDir.getAbsolutePath());
        argList.addElement("-classpath");
        if (Project.getJavaVersion().startsWith("1.1")) {
            argList.addElement(String.valueOf(classpath.toString()) + File.pathSeparator + this.src.toString());
        } else {
            argList.addElement(classpath.toString());
            argList.addElement("-sourcepath");
            argList.addElement(this.src.toString());
            if (this.target != null) {
                argList.addElement("-target");
                argList.addElement(this.target);
            }
        }
        if (this.debug) {
            argList.addElement("-g");
        }
        if (this.optimize) {
            argList.addElement("-O");
        }
        if (this.bootclasspath != null) {
            argList.addElement("-bootclasspath");
            argList.addElement(this.bootclasspath.toString());
        }
        if (this.extdirs != null) {
            argList.addElement("-extdirs");
            argList.addElement(this.extdirs.toString());
        }
        this.log("Compilation args: " + argList.toString(), 3);
        String[] args = new String[argList.size() + this.compileList.size()];
        int counter = 0;
        int i = 0;
        while (i < argList.size()) {
            args[i] = (String)argList.elementAt(i);
            ++counter;
            ++i;
        }
        StringBuffer niceSourceList = new StringBuffer("Files to be compiled:\r\n");
        Enumeration enumeration = this.compileList.elements();
        while (enumeration.hasMoreElements()) {
            args[counter] = (String)enumeration.nextElement();
            niceSourceList.append("    " + args[counter] + "\r\n");
            ++counter;
        }
        this.log(niceSourceList.toString(), 3);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Main compiler = new Main((OutputStream)new TaskOutputStream(this, 1), "javac");
        if (!compiler.compile(args)) {
            throw new BuildException("Compile failed");
        }
    }

    private void doJikesCompile() throws BuildException {
        this.log("Using jikes compiler", 3);
        Path classpath = new Path();
        if (this.bootclasspath != null) {
            classpath.append(this.bootclasspath);
        }
        classpath.append(this.getCompileClasspath(true));
        this.addExtdirsToClasspath(classpath);
        classpath.append(this.src);
        Vector<String> argList = new Vector<String>();
        if (this.deprecation) {
            argList.addElement("-deprecation");
        }
        argList.addElement("-Xstdout");
        argList.addElement("-d");
        argList.addElement(this.destDir.getAbsolutePath());
        argList.addElement("-classpath");
        argList.addElement(classpath.toString());
        if (this.debug) {
            argList.addElement("-g");
        }
        if (this.optimize) {
            argList.addElement("-O");
        }
        boolean emacsMode = false;
        String emacsProperty = this.project.getProperty("build.compiler.emacs");
        if (emacsProperty != null && (emacsProperty.equalsIgnoreCase("on") || emacsProperty.equalsIgnoreCase("true"))) {
            emacsMode = true;
        }
        boolean warnings = true;
        String warningsProperty = this.project.getProperty("build.compiler.warnings");
        if (warningsProperty != null && (warningsProperty.equalsIgnoreCase("off") || warningsProperty.equalsIgnoreCase("false"))) {
            warnings = false;
        }
        if (emacsMode) {
            argList.addElement("+E");
        }
        if (!warnings) {
            argList.addElement("-nowarn");
        }
        this.log("Compilation args: " + argList.toString(), 3);
        String[] args = new String[argList.size() + this.compileList.size()];
        int counter = 0;
        int i = 0;
        while (i < argList.size()) {
            args[i] = (String)argList.elementAt(i);
            ++counter;
            ++i;
        }
        StringBuffer niceSourceList = new StringBuffer("Files to be compiled:\r\n");
        Enumeration enumeration = this.compileList.elements();
        while (enumeration.hasMoreElements()) {
            args[counter] = (String)enumeration.nextElement();
            niceSourceList.append("    " + args[counter] + "\r\n");
            ++counter;
        }
        this.log(niceSourceList.toString(), 3);
        JikesOutputParser jop = new JikesOutputParser(this, emacsMode);
        Jikes compiler = new Jikes(jop, "jikes");
        compiler.compile(args);
        if (jop.getErrorFlag()) {
            String msg = "Compile failed, messages should have been provided.";
            throw new BuildException(msg);
        }
    }

    private void doModernCompile() throws BuildException {
        try {
            Class.forName("com.sun.tools.javac.Main");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.doClassicCompile();
            return;
        }
        this.log("Using modern compiler", 3);
        Path classpath = this.getCompileClasspath(false);
        Vector<String> argList = new Vector<String>();
        if (this.deprecation) {
            argList.addElement("-deprecation");
        }
        argList.addElement("-d");
        argList.addElement(this.destDir.getAbsolutePath());
        argList.addElement("-classpath");
        argList.addElement(classpath.toString());
        argList.addElement("-sourcepath");
        argList.addElement(this.src.toString());
        if (this.target != null) {
            argList.addElement("-target");
            argList.addElement(this.target);
        }
        if (this.debug) {
            argList.addElement("-g");
        }
        if (this.optimize) {
            argList.addElement("-O");
        }
        if (this.bootclasspath != null) {
            argList.addElement("-bootclasspath");
            argList.addElement(this.bootclasspath.toString());
        }
        if (this.extdirs != null) {
            argList.addElement("-extdirs");
            argList.addElement(this.extdirs.toString());
        }
        this.log("Compilation args: " + argList.toString(), 3);
        String[] args = new String[argList.size() + this.compileList.size()];
        int counter = 0;
        int i = 0;
        while (i < argList.size()) {
            args[i] = (String)argList.elementAt(i);
            ++counter;
            ++i;
        }
        StringBuffer niceSourceList = new StringBuffer("Files to be compiled:\r\n");
        Enumeration enumeration = this.compileList.elements();
        while (enumeration.hasMoreElements()) {
            args[counter] = (String)enumeration.nextElement();
            niceSourceList.append("    " + args[counter] + "\r\n");
            ++counter;
        }
        this.log(niceSourceList.toString(), 3);
        try {
            Class<?> c = Class.forName("com.sun.tools.javac.Main");
            Object compiler = c.newInstance();
            Method compile = c.getMethod("compile", new String[0].getClass());
            int result = (Integer)compile.invoke(compiler, new Object[]{args});
            if (result != 0) {
                String msg = "Compile failed, messages should have been provided.";
                throw new BuildException(msg);
            }
        }
        catch (Exception ex) {
            throw new BuildException(ex);
        }
    }

    public void execute() throws BuildException {
        if (this.src == null) {
            throw new BuildException("srcdir attribute must be set!");
        }
        String[] list = this.src.list();
        if (list.length == 0) {
            throw new BuildException("srcdir attribute must be set!");
        }
        if (this.destDir == null) {
            throw new BuildException("destdir attribute must be set!");
        }
        this.resetFileLists();
        int i = 0;
        while (i < list.length) {
            File srcDir = this.project.resolveFile(list[i]);
            if (!srcDir.exists()) {
                throw new BuildException("srcdir " + srcDir.getPath() + " does not exist!");
            }
            DirectoryScanner ds = this.getDirectoryScanner(srcDir);
            String[] files = ds.getIncludedFiles();
            this.scanDir(srcDir, this.destDir, files);
            ++i;
        }
        String compiler = this.project.getProperty("build.compiler");
        if (compiler == null) {
            compiler = Project.getJavaVersion().startsWith("1.3") ? "modern" : "classic";
        }
        if (this.compileList.size() > 0) {
            this.log("Compiling " + this.compileList.size() + " source files to " + this.destDir);
            if (compiler.equalsIgnoreCase("classic")) {
                this.doClassicCompile();
            } else if (compiler.equalsIgnoreCase("modern")) {
                this.doModernCompile();
            } else if (compiler.equalsIgnoreCase("jikes")) {
                this.doJikesCompile();
            } else {
                String msg = "Don't know how to use compiler " + compiler;
                throw new BuildException(msg);
            }
        }
        if (this.filecopyList.size() > 0) {
            this.log("The implicit copying of support files by javac has been deprecated. Use the copydir task to copy support files explicitly.", 1);
            this.log("Copying " + this.filecopyList.size() + " support files to " + this.destDir.getAbsolutePath());
            Enumeration enumeration = this.filecopyList.keys();
            while (enumeration.hasMoreElements()) {
                String fromFile = (String)enumeration.nextElement();
                String toFile = (String)this.filecopyList.get(fromFile);
                try {
                    this.project.copyFile(fromFile, toFile, this.filtering);
                }
                catch (IOException ioe) {
                    String msg = "Failed to copy " + fromFile + " to " + toFile + " due to " + ioe.getMessage();
                    throw new BuildException(msg);
                }
            }
        }
    }

    private Path getCompileClasspath(boolean addRuntime) {
        Path classpath = new Path();
        classpath.setLocation(this.destDir.getAbsolutePath());
        if (this.compileClasspath != null) {
            this.addExistingToClasspath(classpath, this.compileClasspath);
        }
        this.addExistingToClasspath(classpath, Path.systemClasspath);
        if (addRuntime) {
            if (Project.getJavaVersion() == "1.1") {
                this.addExistingToClasspath(classpath, new Path(String.valueOf(System.getProperty("java.home")) + File.separator + "lib" + File.separator + "classes.zip"));
            } else {
                this.addExistingToClasspath(classpath, new Path(String.valueOf(System.getProperty("java.home")) + File.separator + "lib" + File.separator + "rt.jar"));
                this.addExistingToClasspath(classpath, new Path(String.valueOf(System.getProperty("java.home")) + File.separator + "jre" + File.separator + "lib" + File.separator + "rt.jar"));
            }
        }
        return classpath;
    }

    protected void resetFileLists() {
        this.compileList.removeAllElements();
        this.filecopyList.clear();
    }

    protected void scanDir(File srcDir, File destDir, String[] files) {
        long now = new Date().getTime();
        int i = 0;
        while (i < files.length) {
            File srcFile = new File(srcDir, files[i]);
            if (files[i].endsWith(".java")) {
                File classFile = new File(destDir, String.valueOf(files[i].substring(0, files[i].indexOf(".java"))) + ".class");
                if (srcFile.lastModified() > now) {
                    this.log("Warning: file modified in the future: " + files[i], 1);
                }
                if (srcFile.lastModified() > classFile.lastModified()) {
                    this.compileList.addElement(srcFile.getAbsolutePath());
                }
            } else {
                File destFile = new File(destDir, files[i]);
                if (srcFile.lastModified() > destFile.lastModified()) {
                    this.filecopyList.put(srcFile.getAbsolutePath(), destFile.getAbsolutePath());
                }
            }
            ++i;
        }
    }

    public void setBootclasspath(Path bootclasspath) {
        if (this.bootclasspath == null) {
            this.bootclasspath = bootclasspath;
        } else {
            this.bootclasspath.append(bootclasspath);
        }
    }

    public void setClasspath(Path classpath) {
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            this.compileClasspath.append(classpath);
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setDeprecation(boolean deprecation) {
        this.deprecation = deprecation;
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public void setExtdirs(Path extdirs) {
        if (this.extdirs == null) {
            this.extdirs = extdirs;
        } else {
            this.extdirs.append(extdirs);
        }
    }

    public void setFiltering(boolean filter) {
        this.filtering = filter;
    }

    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
    }

    public void setSrcdir(Path srcDir) {
        if (this.src == null) {
            this.src = srcDir;
        } else {
            this.src.append(srcDir);
        }
    }

    public void setTarget(String target) {
        this.target = target;
    }

    class JarFilenameFilter
    implements FilenameFilter {
        JarFilenameFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    }
}

