/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class Replace
extends MatchingTask {
    private File src = null;
    private String token = null;
    private String value = "";
    private File dir = null;

    public void execute() throws BuildException {
        if (this.token == null) {
            throw new BuildException("replace token must not be null");
        }
        if (this.src == null && this.dir == null) {
            throw new BuildException("Either the file or the dir attribute must be specified");
        }
        this.log("Replacing " + this.token + " --> " + this.value);
        if (this.src != null) {
            this.processFile(this.src);
        }
        if (this.dir != null) {
            DirectoryScanner ds = super.getDirectoryScanner(this.dir);
            String[] srcs = ds.getIncludedFiles();
            int i = 0;
            while (i < srcs.length) {
                File file = new File(this.dir, srcs[i]);
                this.processFile(file);
                ++i;
            }
        }
    }

    private void processFile(File src) throws BuildException {
        File temp = new File(String.valueOf(src.getPath()) + ".temp");
        if (temp.exists()) {
            throw new BuildException("Replace: temporary file " + temp.getPath() + " already exists");
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(src));
            BufferedWriter bw = new BufferedWriter(new FileWriter(temp));
            while ((line = br.readLine()) != null) {
                if (line.length() != 0) {
                    bw.write(this.replace(line));
                }
                bw.newLine();
            }
            bw.flush();
            bw.close();
            br.close();
            src.delete();
            temp.renameTo(src);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new BuildException(ioe);
        }
    }

    private String replace(String orig) {
        StringBuffer buffer = new StringBuffer();
        int start = 0;
        int end = 0;
        while ((end = orig.indexOf(this.token, start)) > -1) {
            buffer.append(orig.substring(start, end));
            buffer.append(this.value);
            start = end + this.token.length();
        }
        buffer.append(orig.substring(start));
        return buffer.toString();
    }

    public void setDir(String dirName) {
        this.dir = this.project.resolveFile(dirName);
    }

    public void setFile(String file) {
        this.src = this.project.resolveFile(file);
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

