/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jdom.DataConversionException;
import org.jdom.IllegalNameException;
import org.jdom.Namespace;
import org.jdom.Verifier;

public class Attribute
implements Serializable,
Cloneable {
    protected String name;
    protected transient Namespace namespace;
    protected String value;

    protected Attribute() {
    }

    public Attribute(String string, String string2, Namespace namespace) {
        String string3 = Verifier.checkAttributeName(string);
        if (string3 != null) {
            throw new IllegalNameException(string, "attribute", string3);
        }
        if (namespace == null) {
            namespace = Namespace.NO_NAMESPACE;
        }
        this.name = string;
        this.setValue(string2);
        this.namespace = namespace;
    }

    public Attribute(String string, String string2, String string3, String string4) {
        this(string, string4, Namespace.getNamespace(string2, string3));
    }

    public Attribute(String string, String string2) {
        this(string, string2, Namespace.NO_NAMESPACE);
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.namespace.getPrefix();
        if (string != null && !string.equals("")) {
            stringBuffer.append(string).append(":");
        }
        stringBuffer.append(this.name);
        return stringBuffer.toString();
    }

    public String getNamespacePrefix() {
        return this.namespace.getPrefix();
    }

    public String getNamespaceURI() {
        return this.namespace.getURI();
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String getValue() {
        return this.value;
    }

    public Attribute setValue(String string) {
        this.value = string;
        return this;
    }

    public final String toString() {
        return "[Attribute: " + this.getSerializedForm() + "]";
    }

    public final String getSerializedForm() {
        return this.getQualifiedName() + "=\"" + this.value + "\"";
    }

    public final boolean equals(Object object) {
        return object == this;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final Object clone() {
        Attribute attribute = new Attribute(this.name, this.value, this.namespace);
        return attribute;
    }

    public int getIntValue() throws DataConversionException {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataConversionException(this.name, "int");
        }
    }

    public long getLongValue() throws DataConversionException {
        try {
            return Long.parseLong(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataConversionException(this.name, "long");
        }
    }

    public float getFloatValue() throws DataConversionException {
        try {
            return Float.valueOf(this.value).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataConversionException(this.name, "float");
        }
    }

    public double getDoubleValue() throws DataConversionException {
        try {
            return Double.valueOf(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataConversionException(this.name, "double");
        }
    }

    public boolean getBooleanValue() throws DataConversionException {
        if (this.value.equalsIgnoreCase("true") || this.value.equalsIgnoreCase("on") || this.value.equalsIgnoreCase("yes")) {
            return true;
        }
        if (this.value.equalsIgnoreCase("false") || this.value.equalsIgnoreCase("off") || this.value.equalsIgnoreCase("no")) {
            return false;
        }
        throw new DataConversionException(this.name, "boolean");
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.namespace.getPrefix());
        objectOutputStream.writeObject(this.namespace.getURI());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.namespace = Namespace.getNamespace((String)objectInputStream.readObject(), (String)objectInputStream.readObject());
    }
}

