/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.input;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXBuilder {
    private static final String DEFAULT_SAX_DRIVER = "org.apache.xerces.parsers.SAXParser";
    private boolean validate;
    private String saxDriverClass;
    private ErrorHandler saxErrorHandler;
    private EntityResolver saxEntityResolver;
    private DTDHandler saxDTDHandler;

    public SAXBuilder(String string, boolean bl) {
        this.saxDriverClass = string;
        this.validate = bl;
    }

    public SAXBuilder(String string) {
        this(string, false);
    }

    public SAXBuilder(boolean bl) {
        this(DEFAULT_SAX_DRIVER, bl);
    }

    public SAXBuilder() {
        this(DEFAULT_SAX_DRIVER, false);
    }

    public void setValidation(boolean bl) {
        this.validate = bl;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.saxErrorHandler = errorHandler;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.saxEntityResolver = entityResolver;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.saxDTDHandler = dTDHandler;
    }

    protected Document build(InputSource inputSource) throws JDOMException {
        Document document = new Document(null);
        try {
            XMLReader xMLReader;
            block21: {
                xMLReader = XMLReaderFactory.createXMLReader(this.saxDriverClass);
                SAXHandler sAXHandler = new SAXHandler(document);
                xMLReader.setContentHandler(sAXHandler);
                if (this.saxEntityResolver != null) {
                    xMLReader.setEntityResolver(this.saxEntityResolver);
                }
                if (this.saxDTDHandler != null) {
                    xMLReader.setDTDHandler(this.saxDTDHandler);
                }
                boolean bl = false;
                try {
                    xMLReader.setProperty("http://xml.org/sax/handlers/LexicalHandler", sAXHandler);
                    bl = true;
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {}
                if (!bl) {
                    try {
                        xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", sAXHandler);
                        bl = true;
                    }
                    catch (SAXNotSupportedException sAXNotSupportedException) {
                    }
                    catch (SAXNotRecognizedException sAXNotRecognizedException) {}
                }
                try {
                    xMLReader.setFeature("http://xml.org/sax/features/validation", this.validate);
                    xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
                    xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
                    if (this.saxErrorHandler != null) {
                        xMLReader.setErrorHandler(this.saxErrorHandler);
                    } else {
                        xMLReader.setErrorHandler(sAXHandler);
                    }
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    if (this.validate) {
                        throw new JDOMException("Validation not supported for " + this.saxDriverClass + " SAX Driver");
                    }
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    if (!this.validate) break block21;
                    throw new JDOMException("Validation feature not recognized for " + this.saxDriverClass + " SAX Driver");
                }
            }
            xMLReader.parse(inputSource);
            return document;
        }
        catch (Exception exception) {
            if (exception instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)exception;
                String string = sAXParseException.getSystemId();
                if (string != null) {
                    throw new JDOMException(exception.getMessage(), new JDOMException("Error on line " + sAXParseException.getLineNumber() + " of document " + string + ": " + sAXParseException.getMessage()));
                }
                throw new JDOMException(exception.getMessage(), new JDOMException("Error on line " + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage()));
            }
            throw new JDOMException(exception.getMessage(), exception);
        }
    }

    public Document build(InputStream inputStream) throws JDOMException {
        return this.build(new InputSource(inputStream));
    }

    public Document build(File file) throws JDOMException {
        try {
            URL uRL = this.fileToURL(file);
            return this.build(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new JDOMException(malformedURLException.getMessage(), malformedURLException);
        }
    }

    public Document build(URL uRL) throws JDOMException {
        String string = uRL.toExternalForm();
        return this.build(new InputSource(string));
    }

    public Document build(InputStream inputStream, String string) throws JDOMException {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        return this.build(inputSource);
    }

    public Document build(Reader reader) throws JDOMException {
        return this.build(new InputSource(reader));
    }

    public Document build(Reader reader, String string) throws JDOMException {
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(string);
        return this.build(inputSource);
    }

    public Document build(String string) throws JDOMException {
        return this.build(new InputSource(string));
    }

    protected URL fileToURL(File file) throws MalformedURLException {
        String string = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/") && file.isDirectory()) {
            string = String.valueOf(string) + "/";
        }
        return new URL("file", "", string);
    }
}

