/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.StringTokenizer;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Entity;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.output.NamespaceStack;

public class XMLOutputter
implements Cloneable {
    protected static final String STANDARD_INDENT = "  ";
    private boolean suppressDeclaration = false;
    private String encoding = "UTF8";
    private boolean omitEncoding = false;
    private String indent;
    private int indentLevel;
    private boolean expandEmptyElements = false;
    private boolean newlines = false;
    private String lineSeparator = "\r\n";
    private boolean trimText = false;

    public XMLOutputter() {
    }

    public XMLOutputter(String string) {
        this.indent = string;
    }

    public XMLOutputter(String string, boolean bl) {
        this.indent = string;
        this.newlines = bl;
    }

    public XMLOutputter(String string, boolean bl, String string2) {
        this.indent = string;
        this.newlines = bl;
        this.encoding = string2;
    }

    public XMLOutputter(XMLOutputter xMLOutputter) {
        this.suppressDeclaration = xMLOutputter.suppressDeclaration;
        this.omitEncoding = xMLOutputter.omitEncoding;
        this.indent = xMLOutputter.indent;
        this.indentLevel = xMLOutputter.indentLevel;
        this.expandEmptyElements = xMLOutputter.expandEmptyElements;
        this.newlines = xMLOutputter.newlines;
        this.encoding = xMLOutputter.encoding;
        this.lineSeparator = xMLOutputter.lineSeparator;
        this.trimText = xMLOutputter.trimText;
    }

    public void setLineSeparator(String string) {
        this.lineSeparator = string;
    }

    public void setNewlines(boolean bl) {
        this.newlines = bl;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setOmitEncoding(boolean bl) {
        this.omitEncoding = bl;
    }

    public void setSuppressDeclaration(boolean bl) {
        this.suppressDeclaration = bl;
    }

    public void setExpandEmptyElements(boolean bl) {
        this.expandEmptyElements = bl;
    }

    public void setTrimText(boolean bl) {
        this.trimText = bl;
    }

    public void setIndent(String string) {
        if ("".equals(string)) {
            string = null;
        }
        this.indent = string;
    }

    public void setIndent(boolean bl) {
        if (bl) {
            this.indent = STANDARD_INDENT;
            return;
        }
        this.indent = null;
    }

    public void setIndentLevel(int n) {
        this.indentLevel = n;
    }

    public void setIndentSize(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(" ");
            ++n2;
        }
        this.indent = stringBuffer.toString();
    }

    protected void indent(Writer writer, int n) throws IOException {
        if (this.indent != null && !this.indent.equals("")) {
            int n2 = 0;
            while (n2 < n) {
                writer.write(this.indent);
                ++n2;
            }
        }
    }

    protected void maybePrintln(Writer writer) throws IOException {
        if (this.newlines) {
            writer.write(this.lineSeparator);
        }
    }

    protected Writer makeWriter(OutputStream outputStream) throws UnsupportedEncodingException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(outputStream), this.encoding);
        return outputStreamWriter;
    }

    protected Writer makeWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(outputStream), string);
        return outputStreamWriter;
    }

    public void output(Document document, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.output(document, writer);
        writer.flush();
    }

    public void output(Document document, Writer writer) throws IOException {
        if (this.indentLevel > 0) {
            this.indent(writer, this.indentLevel);
        }
        this.printDeclaration(document, writer, this.encoding);
        if (document.getDocType() != null) {
            if (this.indentLevel > 0) {
                this.indent(writer, this.indentLevel);
            }
            this.printDocType(document.getDocType(), writer);
        }
        Iterator iterator = document.getMixedContent().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof Element) {
                this.output(document.getRootElement(), writer);
                continue;
            }
            if (object instanceof Comment) {
                this.printComment((Comment)object, writer, this.indentLevel);
                continue;
            }
            if (object instanceof ProcessingInstruction) {
                this.printProcessingInstruction((ProcessingInstruction)object, writer, this.indentLevel);
                continue;
            }
            if (!(object instanceof CDATA)) continue;
            this.printCDATASection((CDATA)object, writer, this.indentLevel);
        }
    }

    public void output(Element element, Writer writer) throws IOException {
        this.printElement(element, writer, this.indentLevel, new NamespaceStack());
    }

    public void output(Element element, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.output(element, writer);
        writer.flush();
    }

    public void output(CDATA cDATA, Writer writer) throws IOException {
        this.printCDATASection(cDATA, writer, this.indentLevel);
    }

    public void output(CDATA cDATA, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.output(cDATA, writer);
        writer.flush();
    }

    public void output(Comment comment, Writer writer) throws IOException {
        this.printComment(comment, writer, this.indentLevel);
    }

    public void output(Comment comment, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.output(comment, writer);
        writer.flush();
    }

    public void output(String string, Writer writer) throws IOException {
        this.printString(string, writer);
    }

    public void output(String string, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.printString(string, writer);
        writer.flush();
    }

    public void output(Entity entity, Writer writer) throws IOException {
        this.printEntity(entity, writer);
    }

    public void output(Entity entity, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.printEntity(entity, writer);
        writer.flush();
    }

    public void output(ProcessingInstruction processingInstruction, Writer writer) throws IOException {
        this.printProcessingInstruction(processingInstruction, writer, this.indentLevel);
    }

    public void output(ProcessingInstruction processingInstruction, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.output(processingInstruction, writer);
        writer.flush();
    }

    public String outputString(Document document) throws IOException {
        StringWriter stringWriter = new StringWriter();
        this.output(document, (Writer)stringWriter);
        stringWriter.flush();
        return stringWriter.toString();
    }

    public String outputString(Element element) throws IOException {
        StringWriter stringWriter = new StringWriter();
        this.output(element, (Writer)stringWriter);
        stringWriter.flush();
        return stringWriter.toString();
    }

    public void printDeclaration(Document document, Writer writer, String string) throws IOException {
        if (!this.suppressDeclaration) {
            if (string.equals("UTF8")) {
                writer.write("<?xml version=\"1.0\"");
                if (!this.omitEncoding) {
                    writer.write(" encoding=\"UTF-8\"");
                }
                writer.write("?>");
            } else {
                writer.write("<?xml version=\"1.0\"");
                if (!this.omitEncoding) {
                    writer.write(" encoding=\"" + string + "\"");
                }
                writer.write("?>");
            }
            this.maybePrintln(writer);
        }
    }

    public void printDocType(DocType docType, Writer writer) throws IOException {
        if (docType == null) {
            return;
        }
        String string = docType.getPublicID();
        String string2 = docType.getSystemID();
        boolean bl = false;
        writer.write("<!DOCTYPE ");
        writer.write(docType.getElementName());
        if (string != null && !string.equals("")) {
            writer.write(" PUBLIC \"");
            writer.write(string);
            writer.write("\"");
            bl = true;
        }
        if (string2 != null && !string2.equals("")) {
            if (!bl) {
                writer.write(" SYSTEM");
            }
            writer.write(" \"");
            writer.write(string2);
            writer.write("\"");
        }
        writer.write(">");
        this.maybePrintln(writer);
    }

    protected void printComment(Comment comment, Writer writer, int n) throws IOException {
        this.indent(writer, n);
        writer.write(comment.getSerializedForm());
        this.maybePrintln(writer);
    }

    protected void printProcessingInstruction(ProcessingInstruction processingInstruction, Writer writer, int n) throws IOException {
        this.indent(writer, n);
        writer.write(processingInstruction.getSerializedForm());
        this.maybePrintln(writer);
    }

    protected void printCDATASection(CDATA cDATA, Writer writer, int n) throws IOException {
        this.indent(writer, n);
        writer.write(cDATA.getSerializedForm());
        this.maybePrintln(writer);
    }

    protected void printElement(Element element, Writer writer, int n, NamespaceStack namespaceStack) throws IOException {
        String string;
        List list = element.getMixedContent();
        boolean bl = list.size() == 0;
        boolean bl2 = !bl && list.size() == 1 && list.get(0) instanceof String;
        this.indent(writer, n);
        writer.write("<");
        writer.write(element.getQualifiedName());
        int n2 = namespaceStack.size();
        Namespace namespace = element.getNamespace();
        if (namespace != Namespace.NO_NAMESPACE && namespace != Namespace.XML_NAMESPACE) {
            string = namespace.getPrefix();
            String string2 = namespaceStack.getURI(string);
            if (!namespace.getURI().equals(string2)) {
                namespaceStack.push(namespace);
                this.printNamespace(namespace, writer);
            }
        }
        this.printAttributes(element.getAttributes(), element, writer, namespaceStack);
        if (bl2) {
            String string3 = string = this.trimText ? element.getTextTrim() : element.getText();
            if (string == null || string.equals("")) {
                bl = true;
            }
        }
        if (bl) {
            if (!this.expandEmptyElements) {
                writer.write(" />");
            } else {
                writer.write("></");
                writer.write(element.getQualifiedName());
                writer.write(">");
            }
            this.maybePrintln(writer);
        } else {
            writer.write(">");
            if (bl2) {
                this.printElementContent(element, writer, n, namespaceStack, list);
            } else {
                this.maybePrintln(writer);
                this.printElementContent(element, writer, n, namespaceStack, list);
                this.indent(writer, n);
            }
            writer.write("</");
            writer.write(element.getQualifiedName());
            writer.write(">");
            this.maybePrintln(writer);
        }
        while (namespaceStack.size() > n2) {
            namespaceStack.pop();
        }
    }

    public void printElementContent(Element element, Writer writer) throws IOException {
        List list = element.getMixedContent();
        this.printElementContent(element, writer, this.indentLevel, new NamespaceStack(), list);
    }

    protected void printElementContent(Element element, Writer writer, int n, NamespaceStack namespaceStack, List list) throws IOException {
        boolean bl;
        boolean bl2 = list.size() == 0;
        boolean bl3 = bl = !bl2 && list.size() == 1 && list.get(0) instanceof String;
        if (bl) {
            String string = this.trimText ? element.getTextTrim() : element.getText();
            writer.write(this.escapeElementEntities(string));
            return;
        }
        Object object = null;
        int n2 = 0;
        int n3 = list.size();
        while (n2 < n3) {
            object = list.get(n2);
            if (object instanceof Comment) {
                this.printComment((Comment)object, writer, n + 1);
            } else if (object instanceof String) {
                this.printString((String)object, writer);
            } else if (object instanceof Element) {
                this.printElement((Element)object, writer, n + 1, namespaceStack);
            } else if (object instanceof Entity) {
                this.printEntity((Entity)object, writer);
            } else if (object instanceof ProcessingInstruction) {
                this.printProcessingInstruction((ProcessingInstruction)object, writer, n + 1);
            } else if (object instanceof CDATA) {
                this.printCDATASection((CDATA)object, writer, n + 1);
            }
            ++n2;
        }
    }

    protected void printString(String string, Writer writer) throws IOException {
        string = this.escapeElementEntities(string);
        if (this.trimText) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                writer.write(string2);
                if (!stringTokenizer.hasMoreTokens()) continue;
                writer.write(" ");
            }
            return;
        }
        writer.write(string);
    }

    protected void printEntity(Entity entity, Writer writer) throws IOException {
        writer.write(entity.getSerializedForm());
    }

    protected void printNamespace(Namespace namespace, Writer writer) throws IOException {
        writer.write(" xmlns");
        if (!namespace.getPrefix().equals("")) {
            writer.write(":");
            writer.write(namespace.getPrefix());
        }
        writer.write("=\"");
        writer.write(namespace.getURI());
        writer.write("\"");
    }

    protected void printAttributes(List list, Element element, Writer writer, NamespaceStack namespaceStack) throws IOException {
        new HashSet();
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            Attribute attribute = (Attribute)list.get(n);
            Namespace namespace = attribute.getNamespace();
            if (namespace != Namespace.NO_NAMESPACE && namespace != Namespace.XML_NAMESPACE) {
                String string = namespace.getPrefix();
                String string2 = namespaceStack.getURI(string);
                if (!namespace.getURI().equals(string2)) {
                    this.printNamespace(namespace, writer);
                    namespaceStack.push(namespace);
                }
            }
            writer.write(" ");
            writer.write(attribute.getQualifiedName());
            writer.write("=");
            writer.write("\"");
            writer.write(this.escapeAttributeEntities(attribute.getValue()));
            writer.write("\"");
            ++n;
        }
    }

    private String escapeAttributeEntities(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        String string2 = null;
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            switch (cArray[n]) {
                case '<': {
                    string2 = "&lt;";
                    break;
                }
                case '>': {
                    string2 = "&gt;";
                    break;
                }
                case '\'': {
                    string2 = "&apos;";
                    break;
                }
                case '\"': {
                    string2 = "&quot;";
                    break;
                }
                case '&': {
                    string2 = "&amp;";
                }
            }
            if (string2 != null) {
                stringBuffer.append(cArray, n2, n - n2);
                stringBuffer.append(string2);
                string2 = null;
                n2 = n + 1;
            }
            ++n;
        }
        if (n2 < cArray.length) {
            stringBuffer.append(cArray, n2, n - n2);
        }
        return stringBuffer.toString();
    }

    private String escapeElementEntities(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        String string2 = null;
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            switch (cArray[n]) {
                case '<': {
                    string2 = "&lt;";
                    break;
                }
                case '>': {
                    string2 = "&gt;";
                    break;
                }
                case '&': {
                    string2 = "&amp;";
                }
            }
            if (string2 != null) {
                stringBuffer.append(cArray, n2, n - n2);
                stringBuffer.append(string2);
                string2 = null;
                n2 = n + 1;
            }
            ++n;
        }
        if (n2 < cArray.length) {
            stringBuffer.append(cArray, n2, n - n2);
        }
        return stringBuffer.toString();
    }

    public int parseArgs(String[] stringArray, int n) {
        while (n < stringArray.length) {
            if (stringArray[n].equals("-suppressDeclaration")) {
                this.setSuppressDeclaration(true);
            } else if (stringArray[n].equals("-omitEncoding")) {
                this.setOmitEncoding(true);
            } else if (stringArray[n].equals("-indent")) {
                this.setIndent(stringArray[++n]);
            } else if (stringArray[n].equals("-indentSize")) {
                this.setIndentSize(Integer.parseInt(stringArray[++n]));
            } else if (stringArray[n].equals("-indentLevel")) {
                this.setIndentLevel(Integer.parseInt(stringArray[++n]));
            } else if (stringArray[n].startsWith("-expandEmpty")) {
                this.setExpandEmptyElements(true);
            } else if (stringArray[n].equals("-encoding")) {
                this.setEncoding(stringArray[++n]);
            } else if (stringArray[n].equals("-newlines")) {
                this.setNewlines(true);
            } else if (stringArray[n].equals("-lineSeparator")) {
                this.setLineSeparator(stringArray[++n]);
            } else if (stringArray[n].equals("-trimText")) {
                this.setTrimText(true);
            } else {
                return n;
            }
            ++n;
        }
        return n;
    }
}

