/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.contrib.output;

import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.contrib.output.ElementTreeNode;

public class JTreeOutputter {
    boolean showAttributeCaptions;

    public JTreeOutputter(boolean showCaptionsOnAttributes) {
        this.showAttributeCaptions = this.showAttributeCaptions = true;
    }

    protected String AttributeText(Element elem) {
        String s = "";
        List attribs = elem.getAttributes();
        int size = attribs.size();
        int i = 0;
        while (i < size) {
            Attribute attrib = (Attribute)attribs.get(i);
            s = i == 0 ? String.valueOf(s) + ": " : String.valueOf(s) + ", ";
            s = String.valueOf(s) + attrib.getName() + " = '" + attrib.getValue() + "'";
            ++i;
        }
        return s;
    }

    public void output(Document doc, DefaultMutableTreeNode parent) {
        Iterator i = doc.getMixedContent().iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof Element)) continue;
            this.outputElement((Element)obj, parent);
        }
    }

    protected void outputAttributes(Element elem, DefaultMutableTreeNode parent) {
        List attribs = elem.getAttributes();
        int size = attribs.size();
        if (size > 0) {
            DefaultMutableTreeNode attsNode = new DefaultMutableTreeNode("Attributes");
            parent.add(attsNode);
            int i = 0;
            while (i < size) {
                Attribute attrib = (Attribute)attribs.get(i);
                String s = String.valueOf(attrib.getName()) + " = '" + attrib.getValue() + "'";
                DefaultMutableTreeNode attNode = new DefaultMutableTreeNode(s);
                attsNode.add(attNode);
                ++i;
            }
        }
    }

    protected void outputElement(Element elem, DefaultMutableTreeNode parent) {
        ElementTreeNode node = new ElementTreeNode();
        node.setUserObject(elem);
        parent.add(node);
        if (this.showAttributeCaptions) {
            String s = String.valueOf(elem.getName()) + this.AttributeText(elem);
            node.setCaption(s);
        } else {
            node.setCaption(elem.getName());
            this.outputAttributes(elem, node);
        }
        List mixedContent = elem.getMixedContent();
        int size = mixedContent.size();
        int i = 0;
        while (i < size) {
            Object content = mixedContent.get(i);
            if (content instanceof Element) {
                this.outputElement((Element)content, node);
            } else if (content instanceof String) {
                DefaultMutableTreeNode child = new DefaultMutableTreeNode("'" + content.toString() + "'");
                node.add(child);
            }
            ++i;
        }
    }
}

