/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.contrib.xpath;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Element;
import org.jdom.ProcessingInstruction;
import org.jdom.contrib.xpath.XPathParseException;
import org.jdom.contrib.xpath.a.JDOMLocator;

public class XPathElement {
    public static boolean DEBUG = false;
    private Element element;

    public XPathElement() {
    }

    public XPathElement(Element element) {
        this.extend(element);
    }

    protected static void addDescendants(List list, Element element, String prefix, String localName, boolean self) {
        if (self && (localName == null || localName.equals(element.getName())) && (prefix == null || prefix.equals(element.getNamespacePrefix()))) {
            XPathElement.addUnique(list, element);
        }
        Iterator iter = element.getChildren().iterator();
        while (iter.hasNext()) {
            Element each = (Element)iter.next();
            XPathElement.addDescendants(list, each, prefix, localName, true);
        }
    }

    private static boolean addUnique(List list, Object item) {
        if (!list.contains(item)) {
            return list.add(item);
        }
        return false;
    }

    public XPathElement extend(Element element) {
        this.element = element;
        return this;
    }

    public List getAncestors() {
        ArrayList<Element> result = new ArrayList<Element>();
        Element each = this.element.getParent();
        while (each != null) {
            result.add(each);
            each = each.getParent();
        }
        return result;
    }

    public Attribute getAttribute(String prefix, String localName) {
        Attribute result = this.element.getAttribute(localName);
        if (result != null && prefix != null && !prefix.equals(result.getNamespacePrefix())) {
            result = null;
        }
        return result;
    }

    public Attribute getAttributeMatch(String xpath) throws XPathParseException {
        List matches = this.getMatches(xpath);
        if (matches != null && matches.size() > 0) {
            Iterator iter = matches.iterator();
            while (iter.hasNext()) {
                Object each = iter.next();
                if (!(each instanceof Attribute)) continue;
                return (Attribute)each;
            }
        }
        return null;
    }

    public List getChildren(String prefix, String localName) {
        if (prefix == null) {
            if (localName == null) {
                return this.element.getChildren();
            }
            return this.element.getChildren(localName);
        }
        ArrayList<Element> result = new ArrayList<Element>();
        Iterator iter = this.element.getChildren().iterator();
        while (iter.hasNext()) {
            Element each = (Element)iter.next();
            if (localName != null && !localName.equals(each.getName()) || prefix != null && !prefix.equals(each.getNamespacePrefix())) continue;
            result.add(each);
        }
        return result;
    }

    public Comment getComment() {
        List content = this.element.getMixedContent();
        Iterator iter = content.iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (!(each instanceof Comment)) continue;
            return (Comment)each;
        }
        return null;
    }

    public List getComments() {
        ArrayList result = new ArrayList();
        Iterator iter = this.element.getMixedContent().iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (!(each instanceof Comment)) continue;
            result.add(each);
        }
        return result;
    }

    public List getDescendants(String prefix, String localName, boolean self) {
        ArrayList result = new ArrayList();
        XPathElement.addDescendants(result, this.element, prefix, localName, self);
        return result;
    }

    public Element getElement() {
        return this.element;
    }

    public Element getElementMatch(String xpath) throws XPathParseException {
        List matches = this.getMatches(xpath);
        if (matches != null && matches.size() > 0) {
            Iterator iter = matches.iterator();
            while (iter.hasNext()) {
                Object each = iter.next();
                if (!(each instanceof Element)) continue;
                return (Element)each;
            }
        }
        return null;
    }

    public Object getFirstMatch(String xpath) throws XPathParseException {
        List matches = this.getMatches(xpath);
        if (matches != null && matches.size() > 0) {
            return matches.get(0);
        }
        return null;
    }

    public List getMatches(String xpath) throws XPathParseException {
        JDOMLocator locator = new JDOMLocator();
        locator.setContextElement(this.element);
        List result = locator.match(xpath);
        if (DEBUG) {
            System.out.println(String.valueOf(String.valueOf(this)) + ".getMatches(" + xpath + "): " + result);
        }
        return result;
    }

    public List getNamespaces() {
        List elements = this.getAncestors();
        elements.add(this.element);
        ArrayList result = new ArrayList();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Element each = (Element)iter.next();
            XPathElement.addUnique(result, each.getNamespace());
        }
        return result;
    }

    public List getProcessingInstructions() {
        ArrayList result = new ArrayList();
        Iterator iter = this.element.getMixedContent().iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (!(each instanceof ProcessingInstruction)) continue;
            result.add(each);
        }
        return result;
    }

    public List getProcessingInstructions(String target) {
        List result = this.getProcessingInstructions();
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            ProcessingInstruction each = (ProcessingInstruction)iter.next();
            if (each.getTarget().equals(target)) continue;
            iter.remove();
        }
        return result;
    }

    public Element getRootElement() {
        Element result = this.element;
        while (result != null) {
            if (this.element == null) {
                return result;
            }
            result = this.element;
            this.element = result.getParent();
        }
        return null;
    }

    public List getTextChildren() {
        ArrayList result = new ArrayList();
        Iterator iter = this.element.getMixedContent().iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (!(each instanceof String)) continue;
            result.add(each);
        }
        return result;
    }

    public String getTextMatch(String xpath) throws XPathParseException {
        List matches = this.getMatches(xpath);
        if (matches != null && matches.size() > 0) {
            Iterator iter = matches.iterator();
            while (iter.hasNext()) {
                Object each = iter.next();
                if (!(each instanceof String)) continue;
                return each.toString();
            }
        }
        return null;
    }

    public String toString() {
        return "XPathElement{" + this.element + "}";
    }
}

