/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.contrib.xpath;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.contrib.xpath.XPathParseException;
import org.jdom.contrib.xpath.a.JDOMLocator;

public class XPathElement {
    public static boolean DEBUG;
    private Element element;

    public XPathElement() {
    }

    public XPathElement(Element element) {
        this.extend(element);
    }

    public String toString() {
        return "XPathElement{" + this.element + "}";
    }

    public XPathElement extend(Element element) {
        this.element = element;
        return this;
    }

    public Element getElement() {
        return this.element;
    }

    public List getMatches(String string) throws XPathParseException {
        JDOMLocator jDOMLocator = new JDOMLocator();
        jDOMLocator.setContextElement(this.element);
        List list = jDOMLocator.match(string);
        if (DEBUG) {
            System.out.println(String.valueOf(this) + ".getMatches(" + string + "): " + list);
        }
        return list;
    }

    public Object getFirstMatch(String string) throws XPathParseException {
        List list = this.getMatches(string);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public String getTextMatch(String string) throws XPathParseException {
        List list = this.getMatches(string);
        if (list != null && list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof String)) continue;
                return object.toString();
            }
        }
        return null;
    }

    public Element getElementMatch(String string) throws XPathParseException {
        List list = this.getMatches(string);
        if (list != null && list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof Element)) continue;
                return (Element)object;
            }
        }
        return null;
    }

    public Attribute getAttributeMatch(String string) throws XPathParseException {
        List list = this.getMatches(string);
        if (list != null && list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof Attribute)) continue;
                return (Attribute)object;
            }
        }
        return null;
    }

    public Element getRootElement() {
        Element element = this.element;
        while (element != null) {
            if (this.element == null) {
                return element;
            }
            element = this.element;
            this.element = element.getParent();
        }
        return null;
    }

    public List getAncestors() {
        ArrayList arrayList = new ArrayList();
        Element element = this.element.getParent();
        while (element != null) {
            arrayList.add((Object)element);
            element = element.getParent();
        }
        return arrayList;
    }

    public List getNamespaces() {
        List list = this.getAncestors();
        list.add((Object)this.element);
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            Namespace namespace = element.getNamespace();
            if (arrayList.contains((Object)namespace)) continue;
            arrayList.add((Object)namespace);
        }
        return arrayList;
    }

    public Comment getComment() {
        List list = this.element.getMixedContent();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Comment)) continue;
            return (Comment)object;
        }
        return null;
    }

    public List getComments() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.element.getMixedContent().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Comment)) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    public List getTextChildren() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.element.getMixedContent().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof String)) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    public List getProcessingInstructions() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.element.getMixedContent().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof ProcessingInstruction)) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    public List getProcessingInstructions(String string) {
        List list = this.getProcessingInstructions();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ProcessingInstruction processingInstruction = (ProcessingInstruction)iterator.next();
            if (processingInstruction.getTarget().equals(string)) continue;
            iterator.remove();
        }
        return list;
    }

    public List getChildren(String string, String string2) {
        if (string == null) {
            if (string2 == null) {
                return this.element.getChildren();
            }
            return this.element.getChildren(string2);
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.element.getChildren().iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (string2 != null && !string2.equals(element.getName()) || string != null && !string.equals(element.getNamespacePrefix())) continue;
            arrayList.add((Object)element);
        }
        return arrayList;
    }

    public Attribute getAttribute(String string, String string2) {
        Attribute attribute = this.element.getAttribute(string2);
        if (attribute != null && string != null && !string.equals(attribute.getNamespacePrefix())) {
            attribute = null;
        }
        return attribute;
    }

    public List getDescendants(String string, String string2, boolean bl) {
        ArrayList arrayList = new ArrayList();
        XPathElement.addDescendants((List)arrayList, this.element, string, string2, bl);
        return arrayList;
    }

    protected static void addDescendants(List list, Element element, String string, String string2, boolean bl) {
        Iterator iterator;
        if (bl && (string2 == null || string2.equals(element.getName())) && (string == null || string.equals(element.getNamespacePrefix())) && !list.contains((Object)(iterator = element))) {
            list.add((Object)iterator);
        }
        iterator = element.getChildren().iterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            XPathElement.addDescendants(list, element2, string, string2, true);
        }
    }

    private static boolean addUnique(List list, Object object) {
        if (!list.contains(object)) {
            return list.add(object);
        }
        return false;
    }
}

