/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.contrib.xpath.a;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Element;
import org.jdom.ProcessingInstruction;
import org.jdom.contrib.xpath.XPathElement;
import org.jdom.contrib.xpath.XPathParseException;
import org.jdom.contrib.xpath.a.DefaultHandler;
import org.jdom.contrib.xpath.a.PoCParser;
import org.jdom.contrib.xpath.a.PrintHandler;
import org.jdom.contrib.xpath.a.XPathHandler;
import org.jdom.contrib.xpath.a.XPathParser;
import org.jdom.contrib.xpath.a.XPathPredicateHandler;
import org.jdom.contrib.xpath.impl.Axis;
import org.jdom.contrib.xpath.impl.Nodetype;

public class JDOMLocator
implements XPathHandler {
    public static boolean DEBUG = XPathElement.DEBUG;
    private List matchList;
    private List pathList;
    private List stepList;
    private Element originalContext;
    private XPathParser parser;
    private boolean absolute = false;
    private XPathElement reusableXPathElement;

    public void setMatchList(List list) {
        this.matchList = list;
    }

    public void setContextElement(Element element) {
        this.originalContext = element;
    }

    public void setParser(XPathParser xPathParser) {
        this.parser = xPathParser;
    }

    public List match(String string) throws XPathParseException {
        DEBUG = XPathElement.DEBUG;
        if (DEBUG) {
            System.out.println();
        }
        if (this.parser == null) {
            this.parser = new PoCParser();
        }
        this.parser.setXPathHandler(this);
        this.parser.parse(string);
        return this.matchList;
    }

    public void startParsingXPath() throws XPathParseException {
        if (this.originalContext == null) {
            throw new XPathParseException("JDOMLocator requires a context element.");
        }
        if (this.matchList == null) {
            this.matchList = new ArrayList();
        }
        this.pathList = new ArrayList();
        this.stepList = new ArrayList();
    }

    public void endParsingXPath() throws XPathParseException {
        if (DEBUG) {
            System.out.println((Object)"{/parse}");
        }
    }

    public void startPath() throws XPathParseException {
        if (DEBUG) {
            System.out.print((Object)"{path}");
        }
        this.pathList.add((Object)this.originalContext);
    }

    public void endPath() throws XPathParseException {
        if (DEBUG) {
            System.out.print((Object)"{/path}");
        }
        this.matchList.addAll((Collection)this.pathList);
        this.pathList.clear();
    }

    public void absolute() throws XPathParseException {
        this.absolute = true;
        if (DEBUG) {
            System.out.print((Object)"{absolute}");
        }
        this.pathList.clear();
        this.pathList.add((Object)this.elemext(this.originalContext).getRootElement());
    }

    public void startStep() throws XPathParseException {
        if (DEBUG) {
            System.out.print((Object)"{step}");
        }
    }

    public void nametest(String string, String string2, String string3) throws XPathParseException {
        this.nodetest(string, null, string2, string3);
    }

    public void nodetype(String string, String string2, String string3) throws XPathParseException {
        this.nodetest(string, string2, null, string3);
    }

    public XPathPredicateHandler startXPathPredicate() {
        if (DEBUG) {
            System.out.print((Object)"{pred}");
        }
        return new JDOMLocatorPredicateHandler();
    }

    public void endXPathPredicate(XPathPredicateHandler xPathPredicateHandler) {
        JDOMLocatorPredicateHandler jDOMLocatorPredicateHandler = (JDOMLocatorPredicateHandler)xPathPredicateHandler;
        if (jDOMLocatorPredicateHandler.getPosition() != null) {
            ArrayList arrayList = new ArrayList();
            if (jDOMLocatorPredicateHandler.getPosition() > 0 && this.stepList.size() >= jDOMLocatorPredicateHandler.getPosition()) {
                arrayList.add(this.stepList.get(jDOMLocatorPredicateHandler.getPosition() - 1));
            }
            this.stepList = arrayList;
        }
        if (DEBUG) {
            System.out.print((Object)"{/pred}");
        }
    }

    public void endStep() throws XPathParseException {
        this.pathList = this.stepList;
        this.stepList = new ArrayList();
        if (DEBUG) {
            System.out.print((Object)"{/step}");
        }
    }

    protected static void print(Object object) {
        if (DEBUG) {
            System.out.print(object);
        }
    }

    protected static void println(Object object) {
        if (DEBUG) {
            System.out.println(object);
        }
    }

    protected static void println() {
        if (DEBUG) {
            System.out.println();
        }
    }

    private void nodetest(String string, String string2, String string3, String string4) throws XPathParseException {
        Axis axis = new Axis(string);
        Nodetype nodetype = new Nodetype(string2);
        String string5 = "{nodetest=" + axis.getString() + " " + nodetype.getString() + " " + (string3 == null ? "" : string3) + " " + (string4 == null ? "" : string4) + "}";
        if (DEBUG) {
            System.out.print((Object)string5);
        }
        if ("*".equals(string4)) {
            string4 = null;
        }
        if (axis.getCode() == 0) {
            throw new XPathParseException("Unrecognized axis: " + axis);
        }
        if (nodetype != null && nodetype.getCode() == 0) {
            throw new XPathParseException("Unrecognized nodetype: " + nodetype);
        }
        this.nodetest(axis, nodetype, string3, string4);
    }

    private void nodetest(Axis axis, Nodetype nodetype, String string, String string2) throws XPathParseException {
        Iterator iterator = this.pathList.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            switch (axis.getCode()) {
                case 2: {
                    this.nodetestAncestor(object, nodetype, string, string2, false, true);
                    break;
                }
                case 3: {
                    this.nodetestAncestor(object, nodetype, string, string2, true, true);
                    break;
                }
                case 4: {
                    this.nodetestAttribute(object, nodetype, string, string2);
                    break;
                }
                case 5: {
                    this.nodetestChild(object, nodetype, string, string2);
                    break;
                }
                case 6: {
                    this.nodetestDescendant(object, nodetype, string, string2, false);
                    break;
                }
                case 7: {
                    this.nodetestDescendant(object, nodetype, string, string2, true);
                    break;
                }
                case 8: {
                    throw new NotImplementedException("Support for axis following is not implemented. ");
                }
                case 9: {
                    throw new NotImplementedException("Support for axis following-sibling is not implemented. ");
                }
                case 10: {
                    this.nodetestNamespace(object, nodetype, string, string2);
                    break;
                }
                case 11: {
                    this.nodetestAncestor(object, nodetype, string, string2, true, false);
                    break;
                }
                case 12: {
                    throw new NotImplementedException("Support for axis preceding is not implemented. ");
                }
                case 13: {
                    throw new NotImplementedException("Support for axis preceding-sibling is not implemented. ");
                }
                case 14: {
                    this.nodetestSelf(object, nodetype, string, string2);
                }
            }
        }
    }

    private void nodetestDescendant(Object object, Nodetype nodetype, String string, String string2, boolean bl) throws XPathParseException {
        switch (nodetype.getCode()) {
            case 1: 
            case 5: {
                if (!(object instanceof Element)) break;
                this.stepList.addAll((Collection)this.elemext((Element)object).getDescendants(string, string2, bl));
                return;
            }
        }
    }

    private void nodetestSelf(Object object, Nodetype nodetype, String string, String string2) throws XPathParseException {
        switch (nodetype.getCode()) {
            case 1: {
                this.stepList.add(object);
                return;
            }
            case 5: {
                if (!(object instanceof Element)) break;
                this.stepList.add(object);
                return;
            }
            case 2: {
                if (!(object instanceof Comment)) break;
                this.stepList.add(object);
                return;
            }
            case 3: {
                if (!(object instanceof String)) break;
                this.stepList.add(object);
                return;
            }
            case 4: {
                if (!(object instanceof ProcessingInstruction)) break;
                if (string2 == null) {
                    this.stepList.add(object);
                    return;
                }
                ProcessingInstruction processingInstruction = (ProcessingInstruction)object;
                if (!string2.equals(processingInstruction.getTarget())) break;
                this.stepList.add(object);
                return;
            }
        }
    }

    private void nodetestAncestor(Object object, Nodetype nodetype, String string, String string2, boolean bl, boolean bl2) throws XPathParseException {
        if ((nodetype.getCode() == 5 || nodetype.getCode() == 1) && object instanceof Element) {
            Element element = (Element)object;
            if (bl) {
                this.stepList.add((Object)element);
            }
            if (bl2) {
                this.stepList.addAll((Collection)this.elemext(element).getAncestors());
                return;
            }
            this.stepList.add((Object)element.getParent());
        }
    }

    private void nodetestChild(Object object, Nodetype nodetype, String string, String string2) throws XPathParseException {
        if (!(object instanceof Element)) {
            return;
        }
        Element element = (Element)object;
        switch (nodetype.getCode()) {
            case 1: {
                if (string2 == null) {
                    this.stepList.addAll((Collection)element.getMixedContent());
                    return;
                }
                throw new XPathParseException("LocalName for nodes is meaningless.  (localName=" + string2 + ")");
            }
            case 5: {
                this.stepList.addAll((Collection)this.elemext(element).getChildren(string, string2));
                return;
            }
            case 2: {
                if (string2 == null) {
                    this.stepList.addAll((Collection)this.elemext(element).getComments());
                    return;
                }
                throw new XPathParseException("LocalName for comments is meaningless.  (localName=" + string2 + ")");
            }
            case 3: {
                if (string2 == null) {
                    this.stepList.addAll((Collection)this.elemext(element).getTextChildren());
                    return;
                }
                throw new XPathParseException("LocalName for text is meaningless.  (localName=" + string2 + ")");
            }
            case 4: {
                if (string2 == null) {
                    this.stepList.addAll((Collection)this.elemext(element).getProcessingInstructions());
                    return;
                }
                this.stepList.addAll((Collection)this.elemext(element).getProcessingInstructions(string2));
                return;
            }
        }
    }

    private void nodetestNamespace(Object object, Nodetype nodetype, String string, String string2) throws XPathParseException {
        if ((nodetype.getCode() == 5 || nodetype.getCode() == 1) && object instanceof Element) {
            Element element = (Element)object;
            this.stepList.addAll((Collection)this.elemext(element).getNamespaces());
        }
    }

    private void nodetestAttribute(Object object, Nodetype nodetype, String string, String string2) throws XPathParseException {
        if (!(object instanceof Element)) {
            return;
        }
        Element element = (Element)object;
        switch (nodetype.getCode()) {
            case 5: {
                Attribute attribute;
                if (string2 == null) {
                    if (DEBUG) {
                        System.out.print((Object)"*");
                    }
                    this.stepList.addAll((Collection)element.getAttributes());
                    return;
                }
                if (DEBUG) {
                    System.out.print((Object)"#");
                }
                if ((attribute = this.elemext(element).getAttribute(string, string2)) == null) break;
                this.stepList.add((Object)attribute);
                return;
            }
            default: {
                throw new XPathParseException("Cannot have axis=ATTRIBUTE for any other than nodetype=ELEMENT.");
            }
        }
    }

    private XPathElement elemext(Element element) {
        if (this.reusableXPathElement == null) {
            this.reusableXPathElement = new XPathElement(element);
        } else {
            this.reusableXPathElement.extend(element);
        }
        return this.reusableXPathElement;
    }

    class JDOMLocatorPredicateHandler
    extends DefaultHandler
    implements XPathPredicateHandler {
        private Integer position;

        JDOMLocatorPredicateHandler() {
            JDOMLocator.this = JDOMLocator.this;
            PrintHandler.DEBUG = XPathElement.DEBUG;
        }

        Integer getPosition() {
            return this.position;
        }

        public void startPredicate() throws XPathParseException {
        }

        public void endPredicate() throws XPathParseException {
        }

        public void number(String string) throws XPathParseException {
            String string2 = "{number=" + string + "}";
            if (PrintHandler.DEBUG) {
                System.out.print((Object)string2);
            }
            if (string.indexOf(46) == -1) {
                this.position = new Integer(string);
                return;
            }
            throw new NotImplementedException("Support for position numbers only are implemented. " + string);
        }
    }

    class NotImplementedException
    extends XPathParseException {
        public NotImplementedException(String string) {
            super(string);
            JDOMLocator.this = JDOMLocator.this;
        }

        public NotImplementedException(String string, Throwable throwable) {
            super(string, throwable);
            JDOMLocator.this = JDOMLocator.this;
        }
    }
}

