@echo off
rem ---------------------------------------------------------------------------
rem catalina.bat - Start/Stop Script for the CATALINA Server
rem
rem Environment Variable Prequisites:
rem
rem   CATALINA_HOME (Optional) May point at your Catalina "build" directory.
rem                 If not present, the current working directory is assumed.
rem                 Note: This batch file does not function properly if
rem                 CATALINA_HOME contains spaces.
rem   CATALINA_OPTS (Optional) Java runtime options used when the "start",
rem                 "stop", or "run" command is executed.
rem   CLASSPATH     Must contain the "jaxp.jar" and "parser.jar" files from
rem                 the JAXP Reference Implementation, version 1.0 or later,
rem                 or these files must be in your Java2 extensions directory.
rem                 This batch file will automatically add additional entries
rem                 that Catalina needs to the CLASSPATH.  This consists
rem                 of CATALINA_HOME\classes, all the jar files in
rem                 CATALINA_HOME\lib, and the "tools.jar" from the JDK.
rem   JAVA_HOME     Must point at your Java Development Kit installation.
rem
rem $Id: catalina.bat,v 1.12.2.3 2000/09/04 21:27:08 larryi Exp $
rem ---------------------------------------------------------------------------


rem ----- Save Environment Variables That May Change --------------------------

set _CATALINA_HOME=%CATALINA_HOME%
set _CP=%CP%
set _CLASSPATH=%CLASSPATH%


rem ----- Verify and Set Required Environment Variables -----------------------

if not "%JAVA_HOME%" == "" goto gotJavaHome
echo You must set JAVA_HOME to point at your Java Development Kit installation
goto cleanup
:gotJavaHome

if not "%CATALINA_HOME%" == "" goto gotCatalinaHome
set CATALINA_HOME=.
:gotCatalinaHome
if exist "%CATALINA_HOME%\lib\webserver.jar" goto okCatalinaHome
echo Unable to locate webserver.jar, check the value of CATALINA_HOME.
goto cleanup
:okCatalinaHome


rem ----- Prepare Appropriate Java Execution Commands -----------------------

if not "%OS%" == "Windows_NT" goto noTitle
set _STARTJAVA=start "Catalina" "%JAVA_HOME%\bin\java"
set _RUNJAVA="%JAVA_HOME%\bin\java"
goto setClasspath

:noTitle
set _STARTJAVA=start "%JAVA_HOME%\bin\java"
set _RUNJAVA="%JAVA_HOME%\bin\java"


rem ----- Set Up The Runtime Classpath ----------------------------------------

:setClasspath
set CP=%CATALINA_HOME%\classes

rem Try to determine if CATALINA_HOME contains spaces
if exist %CATALINA_HOME%\lib\webserver.jar goto dynClasspath
echo Your CATALINA_HOME appears to contain spaces.
echo Unable to set CLASSPATH dynamically.
goto staticClasspath

:dynClasspath
set _LIBJARS=
for %%i in (%CATALINA_HOME%\lib\*.jar) do call %CATALINA_HOME%\bin\cpappend.bat %%i
if not "%_LIBJARS%" == "" goto gotLibJars
echo Unable to set CLASSPATH dynamically.
if "%OS%" == "Windows_NT" goto staticClasspath
echo Note: To set the CLASSPATH dynamically on Win9x systems
echo       only DOS 8.3 names may be used in CATALINA_HOME!
goto staticClasspath

:gotLibJars
echo Including all jars in %CATALINA_HOME%\lib in your CLASSPATH.
rem Note: _LIBJARS already contains a leading semicolon
set CP=%CP%%_LIBJARS%
goto chkClasspath

:staticClasspath
echo Setting your CLASSPATH statically.
set CP=%CP%;%CATALINA_HOME%\lib\ant.jar
set CP=%CP%;%CATALINA_HOME%\lib\jasper.jar
set CP=%CP%;%CATALINA_HOME%\lib\regexp.jar
set CP=%CP%;%CATALINA_HOME%\lib\servlet.jar
set CP=%CP%;%CATALINA_HOME%\lib\webserver.jar

:chkClasspath
if "%CLASSPATH%" == "" goto noClasspath
set CP=%CP%;%CLASSPATH%
:noClasspath
if not exist "%JAVA_HOME%\lib\tools.jar" goto installClasspath
set CP=%CP%;%JAVA_HOME%\lib\tools.jar
:installClasspath
echo.
echo Using CLASSPATH: %CP%
echo.
set CLASSPATH=%CP%


rem ----- Execute The Requested Command ---------------------------------------

if "%1" == "env" goto doEnv
if "%1" == "run" goto doRun
if "%1" == "start" goto doStart
if "%1" == "stop" goto doStop

:doUsage
echo Usage:  catalina ( env | run | start | stop )
echo Commands:
echo   env -   Set up environment variables that Catalina would use
echo   run -   Start Catalina in the current window
echo   start - Start Catalina in a separate window
echo   stop -  Stop Catalina
goto cleanup

:doEnv
goto finish

:doRun
%_RUNJAVA% %CATALINA_OPTS% -Dcatalina.home="%CATALINA_HOME%" org.apache.tomcat.startup.Catalina %2 %3 %4 %5 %6 %7 %8 %9 start
goto cleanup


:doStart
%_STARTJAVA% %CATALINA_OPTS% -Dcatalina.home="%CATALINA_HOME%" org.apache.tomcat.startup.Catalina %2 %3 %4 %5 %6 %7 %8 %9 start
goto cleanup

:doStop
%_RUNJAVA% %CATALINA_OPTS% -Dcatalina.home="%CATALINA_HOME%" org.apache.tomcat.startup.Catalina %2 %3 %4 %5 %6 %7 %8 %9 stop
goto cleanup



rem ----- Restore Environment Variables ---------------------------------------

:cleanup
set _LIBJARS=
set _STARTJAVA=
set _RUNJAVA=
set CATALINA_HOME=%_CATALINA_HOME%
set _CATALINA_HOME=
set CP=%_CP%
set _CP=
set CLASSPATH=%_CLASSPATH%
set _CLASSPATH=
:finish
