#!/bin/sh
# -----------------------------------------------------------------------------
# catalina.sh - Start/Stop Script for the CATALINA Server
#
# Environment Variable Prequisites
#
#   CATALINA_HOME (Optional) May point at your Catalina "build" directory.
#                 If not present, the current working directory is assumed.
#   CATALINA_OPTS (Optional) Java runtime options used when the "start",
#                 "stop", or "run" command is executed.
#   CLASSPATH     Must contain the "jaxp.jar" and "parser.jar" files from
#                 the JAXP Reference Implementation, version 1.0, or these
#                 files must be in your Java2 extensions directory.
#   JAVA_HOME     Must point at your Java Development Kit installation.
#
# $Id: catalina.sh,v 1.10 2000/06/23 17:52:37 craigmcc Exp $
# -----------------------------------------------------------------------------


# ----- Verify and Set Required Environment Variables -------------------------

if [ "$CATALINA_HOME" = "" ] ; then
  CATALINA_HOME=`pwd`
fi

if [ "$CATALINA_OPTS" = "" ] ; then
  CATALINA_OPTS=""
fi

if [ "$JAVA_HOME" = "" ] ; then
  echo You must set JAVA_HOME to point at your Java Development Kit installation
  exit 1
fi

# ----- Set Up The Runtime Classpath

CP=$CATALINA_HOME/classes
if [ -f $JAVA_HOME/lib/tools.jar ] ; then
  CP=$CP:$JAVA_HOME/lib/tools.jar
fi
for i in $CATALINA_HOME/lib/* ; do
  CP=$CP:$i
done
if [ "$CLASSPATH" != "" ] ; then
  CP=$CP:$CLASSPATH
fi

echo Using CLASSPATH: $CP


# ----- Execute The Requested Command -----------------------------------------

if [ "$1" = "debug" ] ; then

  pushd $CATALINA_HOME
  jdb \
     -sourcepath ../../jakarta-tomcat/proposals/catalina:../../jakarta-tomcat \
     -classpath $CP -Dcatalina.home=$CATALINA_HOME \
     org.apache.tomcat.startup.Catalina "$@" start
  popd

elif [ "$1" = "env" ] ; then

  export CATALINA_HOME CP
  exit 0

elif [ "$1" = "run" ] ; then

  shift
  java $CATALINA_OPTS -classpath $CP -Dcatalina.home=$CATALINA_HOME \
   org.apache.tomcat.startup.Catalina "$@" start

elif [ "$1" = "start" ] ; then

  shift
  touch $CATALINA_HOME/logs/catalina.out
  java $CATALINA_OPTS -classpath $CP -Dcatalina.home=$CATALINA_HOME \
   org.apache.tomcat.startup.Catalina "$@" start \
   >> $CATALINA_HOME/logs/catalina.out 2>&1 &

elif [ "$1" = "stop" ] ; then

  shift
  java $CATALINA_OPTS -classpath $CP -Dcatalina.home=$CATALINA_HOME \
   org.apache.tomcat.startup.Catalina "$@" stop

else

  echo "Usage: catalina.sh ( env | run | start | stop)"
  echo "Commands:"
  echo "  debug - Start Catalina in a debugger"
  echo "  env -   Set up environment variables that Catalina would use"
  echo "  run -   Start Catalina in the current window"
  echo "  start - Start Catalina in a separate window"
  echo "  stop -  Stop Catalina"
  exit 1

fi
