/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.debug;

import sun.tools.agent.AgentConstants;
import sun.tools.debug.LocalVariable;
import sun.tools.debug.RemoteStackFrame;
import sun.tools.debug.RemoteValue;
import sun.tools.java.Type;

public class RemoteStackVariable
extends LocalVariable
implements AgentConstants {
    RemoteStackFrame frame;
    RemoteValue value;

    RemoteStackVariable(RemoteStackFrame remoteStackFrame, int n, String string, String string2, boolean bl, RemoteValue remoteValue) {
        this.frame = remoteStackFrame;
        this.slot = n;
        this.name = string;
        this.signature = string2;
        this.methodArgument = bl;
        this.value = remoteValue;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return Type.tType(this.signature);
    }

    public RemoteValue getValue() {
        return this.value;
    }

    public boolean inScope() {
        return this.slot != -1;
    }

    public boolean methodArgument() {
        return this.methodArgument;
    }

    void setValue(char c) throws IllegalAccessException, Exception {
        if (this.getType().getTypeCode() != 2) {
            throw new IllegalAccessException();
        }
        this.frame.setVariable(this.slot, c);
    }

    void setValue(double d) throws IllegalAccessException, Exception {
        if (this.getType().getTypeCode() != 7) {
            throw new IllegalAccessException();
        }
        this.frame.setVariable(this.slot, d);
    }

    void setValue(float f) throws IllegalAccessException, Exception {
        if (this.getType().getTypeCode() != 6) {
            throw new IllegalAccessException();
        }
        this.frame.setVariable(this.slot, f);
    }

    void setValue(int n) throws IllegalAccessException, Exception {
        int n2 = this.getType().getTypeCode();
        if (n2 == 5) {
            this.setValue((long)n);
            return;
        }
        if (n2 != 4 && n2 != 1 && n2 != 3) {
            throw new IllegalAccessException();
        }
        this.frame.setVariable(this.slot, n);
    }

    void setValue(long l) throws IllegalAccessException, Exception {
        if (this.getType().getTypeCode() != 5) {
            throw new IllegalAccessException();
        }
        this.frame.setVariable(this.slot, l);
    }

    void setValue(boolean bl) throws IllegalAccessException, Exception {
        if (this.getType().getTypeCode() != 0) {
            throw new IllegalAccessException();
        }
        this.frame.setVariable(this.slot, bl);
    }
}

