/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ClassFile {
    private File file;
    private ZipFile zipFile;
    private ZipEntry zipEntry;

    public ClassFile(File file) {
        this.file = file;
    }

    public ClassFile(ZipFile zipFile, ZipEntry zipEntry) {
        this.zipFile = zipFile;
        this.zipEntry = zipEntry;
    }

    public boolean exists() {
        return this.file != null ? this.file.exists() : true;
    }

    public String getAbsoluteName() {
        String string;
        if (this.file != null) {
            try {
                string = this.file.getCanonicalPath();
            }
            catch (IOException iOException) {
                string = this.file.getAbsolutePath();
            }
        } else {
            string = String.valueOf(this.zipFile.getName()) + "(" + this.zipEntry.getName() + ")";
        }
        return string;
    }

    public InputStream getInputStream() throws IOException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        try {
            return this.zipFile.getInputStream(this.zipEntry);
        }
        catch (ZipException zipException) {
            throw new IOException(zipException.getMessage());
        }
    }

    public String getName() {
        return this.file != null ? this.file.getName() : this.zipEntry.getName();
    }

    public String getPath() {
        if (this.file != null) {
            return this.file.getPath();
        }
        return String.valueOf(this.zipFile.getName()) + "(" + this.zipEntry.getName() + ")";
    }

    public boolean isDirectory() {
        return this.file != null ? this.file.isDirectory() : this.zipEntry.getName().endsWith("/");
    }

    public boolean isZipped() {
        return this.zipFile != null;
    }

    public long lastModified() {
        return this.file != null ? this.file.lastModified() : this.zipEntry.getTime();
    }

    public long length() {
        return this.file != null ? this.file.length() : this.zipEntry.getSize();
    }

    public String toString() {
        return this.file != null ? this.file.toString() : this.zipEntry.toString();
    }
}

