/*
 * $Header: /home/cvspublic/jakarta-watchdog/src/server/servlet-tests/WEB-INF/classes/tests/javax_servlet_http/HttpUtils/ParsePostDataTestServlet.java,v 1.2 1999/11/09 21:00:22 costin Exp $
 * $Date: 1999/11/09 21:00:22 $
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Tomcat", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */


package tests.javax_servlet_http.HttpUtils;

import org.apache.tools.moo.servlet.ServletTest;
import org.apache.tools.moo.servlet.Constants;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import javax.servlet.ServletConfig;
import javax.servlet.ServletInputStream;
import java.util.Properties;
import java.util.Hashtable;
import java.util.Enumeration;
import javax.servlet.ServletException;
import java.io.IOException;


/**
 *	A Test for parsePostData(int,ServletInputStream) method
 */


public class ParsePostDataTestServlet extends ServletTest {

/*
 *	ParsePostData Parses POST data and returns a
 *	Hashtable of key value pairs
 */

	public String getTitle() {

		return "ParsePostDataTestServlet";
	}

	/* A small description about the Test */

	public String getDescription() {
		return "ParsePostDataTestServlet";
	}

	public Properties doTest (HttpServletRequest request,
		HttpServletResponse response)

	throws ServletException,IOException{

		Properties props = new Properties();
		try {


		props.put(Constants.Response.Title, getTitle());
		props.put(Constants.Response.Description,getDescription());

		int length=0;

		int len=request.getContentLength();


		String msg = "Values not parsed properly"; // Failed
		String status = "false"; //  setting status to false

		ServletInputStream sis = request.getInputStream();

		Hashtable hash = HttpUtils.parsePostData(len,sis);

		Enumeration enum = hash.keys();

		int count =0;

		while(enum.hasMoreElements()) {

			enum.nextElement();
			count++;
		}


		if(count==2) {

			enum = hash.keys();

		/* Checking whether what is got is what we set */

			while(enum.hasMoreElements()) {

				String keyName=(String)enum.nextElement();

				if(keyName.equals("Keyed")||keyName.equals("locks")){
					msg="Ok";
					status="true";
				}
				else {
					 msg="Values not parsed properly"; //Failed
					 status="false";// setting status to false
				}
			}

			/* Checking the integrity of the key:value pair */


			/**if(status.equals("true")) {

				String keyName1="keyed";
				String keyName2="locks";

				String value1=(String)hash.get(keyName1);
				String value2=(String)hash.get(keyName2);


				if((!value1.equals("val")) || (!value2.equals("theft"))) {
					 msg = "Values not parsed properly"; // Failed
					 status = "false"; //  setting status to false
				}
			}**/
		}

		props.put(Constants.Response.Status, status);
		props.put(Constants.Response.Message, msg);

		}catch(Exception e) {
			e.printStackTrace();
		}
		return props;

	}
}
