/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.StringTokenizer;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Entity;
import org.jdom.IllegalAddException;
import org.jdom.IllegalNameException;
import org.jdom.Namespace;
import org.jdom.PartialList;
import org.jdom.ProcessingInstruction;
import org.jdom.Verifier;

public class Element
implements Serializable,
Cloneable {
    protected String name;
    protected transient Namespace namespace;
    protected Element parent;
    protected Document document;
    protected List attributes;
    protected List content;

    protected Element() {
    }

    public Element(String string, Namespace namespace) {
        String string2 = Verifier.checkElementName(string);
        if (string2 != null) {
            throw new IllegalNameException(string, "element", string2);
        }
        this.name = string;
        if (namespace == null) {
            namespace = Namespace.NO_NAMESPACE;
        }
        this.namespace = namespace;
        this.document = null;
    }

    public Element(String string) {
        this(string, Namespace.NO_NAMESPACE);
    }

    public Element(String string, String string2) {
        this(string, Namespace.getNamespace("", string2));
    }

    public Element(String string, String string2, String string3) {
        this(string, Namespace.getNamespace(string2, string3));
    }

    public Element getCopy(String string, Namespace namespace) {
        Element element = (Element)this.clone();
        element.namespace = namespace;
        element.name = string;
        return element;
    }

    public Element getCopy(String string) {
        return this.getCopy(string, Namespace.NO_NAMESPACE);
    }

    public String getName() {
        return this.name;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String getNamespacePrefix() {
        return this.namespace.getPrefix();
    }

    public String getNamespaceURI() {
        return this.namespace.getURI();
    }

    public String getQualifiedName() {
        if (this.namespace.getPrefix().equals("")) {
            return this.getName();
        }
        return this.namespace.getPrefix() + ":" + this.name;
    }

    public Element getParent() {
        return this.parent;
    }

    protected Element setParent(Element element) {
        this.parent = element;
        return this;
    }

    public boolean isRootElement() {
        return this.document != null;
    }

    protected Element setDocument(Document document) {
        this.document = document;
        return this;
    }

    public Document getDocument() {
        if (this.isRootElement()) {
            return this.document;
        }
        if (this.getParent() != null) {
            return this.getParent().getDocument();
        }
        return null;
    }

    public String getText() {
        if (this.content == null || this.content.size() < 1 || this.content.get(0) == null) {
            return "";
        }
        if (this.content.size() == 1 && this.content.get(0) instanceof String) {
            return (String)this.content.get(0);
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        Iterator iterator = this.content.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof String) {
                stringBuffer.append((String)object);
                bl = true;
                continue;
            }
            if (!(object instanceof CDATA)) continue;
            stringBuffer.append(((CDATA)object).getText());
            bl = true;
        }
        if (!bl) {
            return "";
        }
        return stringBuffer.toString();
    }

    public String getTextTrim() {
        String string = this.getText();
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            stringBuffer.append(string2);
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public String getChildText(String string) {
        Element element = this.getChild(string);
        if (element == null) {
            return null;
        }
        return element.getText();
    }

    public String getChildTextTrim(String string) {
        Element element = this.getChild(string);
        if (element == null) {
            return null;
        }
        return element.getTextTrim();
    }

    public String getChildText(String string, Namespace namespace) {
        Element element = this.getChild(string, namespace);
        if (element == null) {
            return null;
        }
        return element.getText();
    }

    public String getChildTextTrim(String string, Namespace namespace) {
        Element element = this.getChild(string, namespace);
        if (element == null) {
            return null;
        }
        return element.getTextTrim();
    }

    public Element setText(String string) {
        if (this.content != null) {
            this.content.clear();
        } else {
            this.content = new LinkedList();
        }
        this.content.add((Object)string);
        return this;
    }

    public boolean hasMixedContent() {
        if (this.content == null) {
            return false;
        }
        Class<?> clazz = null;
        Iterator iterator = this.content.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            Class<?> clazz2 = object.getClass();
            if (clazz2 == clazz) continue;
            if (clazz != null) {
                return true;
            }
            clazz = clazz2;
        }
        return false;
    }

    public List getMixedContent() {
        if (this.content == null) {
            this.content = new LinkedList();
        }
        PartialList partialList = new PartialList(this.content, this);
        partialList.addAllPartial((Collection)this.content);
        return partialList;
    }

    public Element setMixedContent(List list) {
        if (this.content != null) {
            this.content.clear();
        } else {
            this.content = new LinkedList();
        }
        this.content.addAll((Collection)list);
        return this;
    }

    public List getChildren() {
        if (this.content == null) {
            this.content = new LinkedList();
        }
        PartialList partialList = new PartialList(this.content, this);
        Iterator iterator = this.content.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Element)) continue;
            partialList.addPartial(object);
        }
        return partialList;
    }

    public Element setChildren(List list) {
        return this.setMixedContent(list);
    }

    public List getChildren(String string) {
        return this.getChildren(string, Namespace.NO_NAMESPACE);
    }

    public List getChildren(String string, Namespace namespace) {
        PartialList partialList = new PartialList(this.getChildren(), this);
        if (this.content != null) {
            String string2 = namespace.getURI();
            Iterator iterator = this.content.iterator();
            while (iterator.hasNext()) {
                Element element;
                Object object = iterator.next();
                if (!(object instanceof Element) || !(element = (Element)object).getNamespaceURI().equals(string2) || !element.getName().equals(string)) continue;
                partialList.addPartial(element);
            }
        }
        return partialList;
    }

    public Element getChild(String string, Namespace namespace) {
        if (this.content == null) {
            return null;
        }
        String string2 = namespace.getURI();
        Iterator iterator = this.content.iterator();
        while (iterator.hasNext()) {
            Element element;
            Object object = iterator.next();
            if (!(object instanceof Element) || !(element = (Element)object).getNamespaceURI().equals(string2) || !element.getName().equals(string)) continue;
            return element;
        }
        return null;
    }

    public Element getChild(String string) {
        return this.getChild(string, Namespace.NO_NAMESPACE);
    }

    public Element addContent(String string) {
        Object object;
        if (this.content == null) {
            this.content = new LinkedList();
        }
        if (this.content.size() > 0 && (object = this.content.get(this.content.size() - 1)) instanceof String) {
            string = String.valueOf((String)object) + string;
            this.content.remove(object);
        }
        this.content.add((Object)string);
        return this;
    }

    public Element addContent(Element element) {
        if (element.isRootElement()) {
            throw new IllegalAddException(this, element, "The element already has an existing parent (the document root)");
        }
        if (element.getParent() != null) {
            throw new IllegalAddException(this, element, "The element already has an existing parent \"" + element.getParent().getQualifiedName() + "\"");
        }
        if (this.content == null) {
            this.content = new LinkedList();
        }
        element.setParent(this);
        this.content.add((Object)element);
        return this;
    }

    public Element addContent(ProcessingInstruction processingInstruction) {
        if (this.content == null) {
            this.content = new LinkedList();
        }
        this.content.add((Object)processingInstruction);
        return this;
    }

    public Element addContent(Entity entity) {
        if (this.content == null) {
            this.content = new LinkedList();
        }
        this.content.add((Object)entity);
        return this;
    }

    public Element addContent(CDATA cDATA) {
        if (this.content == null) {
            this.content = new LinkedList();
        }
        this.content.add((Object)cDATA);
        return this;
    }

    public Element addContent(Comment comment) {
        if (this.content == null) {
            this.content = new LinkedList();
        }
        this.content.add((Object)comment);
        return this;
    }

    public boolean removeChild(String string) {
        return this.removeChild(string, Namespace.NO_NAMESPACE);
    }

    public boolean removeChild(String string, Namespace namespace) {
        if (this.content == null) {
            return false;
        }
        String string2 = namespace.getURI();
        Iterator iterator = this.content.iterator();
        while (iterator.hasNext()) {
            Element element;
            Object object = iterator.next();
            if (!(object instanceof Element) || !(element = (Element)object).getNamespaceURI().equals(string2) || !element.getName().equals(string)) continue;
            element.setParent(null);
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean removeChildren(String string) {
        return this.removeChildren(string, Namespace.NO_NAMESPACE);
    }

    public boolean removeChildren(String string, Namespace namespace) {
        if (this.content == null) {
            return false;
        }
        String string2 = namespace.getURI();
        boolean bl = false;
        Iterator iterator = this.content.iterator();
        while (iterator.hasNext()) {
            Element element;
            Object object = iterator.next();
            if (!(object instanceof Element) || !(element = (Element)object).getNamespaceURI().equals(string2) || !element.getName().equals(string)) continue;
            element.setParent(null);
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public boolean removeChildren() {
        if (this.content != null) {
            Iterator iterator = this.content.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof Element)) continue;
                iterator.remove();
            }
        }
        return true;
    }

    public List getAttributes() {
        if (this.attributes == null) {
            this.attributes = new LinkedList();
        }
        PartialList partialList = new PartialList(this.attributes, this);
        partialList.addAllPartial((Collection)this.attributes);
        return partialList;
    }

    public Attribute getAttribute(String string) {
        return this.getAttribute(string, Namespace.NO_NAMESPACE);
    }

    public Attribute getAttribute(String string, Namespace namespace) {
        if (this.attributes == null) {
            return null;
        }
        String string2 = namespace.getURI();
        Iterator iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (!attribute.getNamespaceURI().equals(string2) || !attribute.getName().equals(string)) continue;
            return attribute;
        }
        return null;
    }

    public String getAttributeValue(String string) {
        return this.getAttributeValue(string, Namespace.NO_NAMESPACE);
    }

    public String getAttributeValue(String string, Namespace namespace) {
        Attribute attribute = this.getAttribute(string, namespace);
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }

    public Element setAttributes(List list) {
        this.attributes = list;
        return this;
    }

    public Element addAttribute(Attribute attribute) {
        if (this.getAttribute(attribute.getName(), attribute.getNamespace()) != null) {
            throw new IllegalAddException(this, attribute, "Duplicate attributes are not allowed.");
        }
        if (this.attributes == null) {
            this.attributes = new LinkedList();
        }
        this.attributes.add((Object)attribute);
        return this;
    }

    public Element addAttribute(String string, String string2) {
        return this.addAttribute(new Attribute(string, string2));
    }

    public boolean removeAttribute(String string, String string2) {
        Iterator iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (!attribute.getNamespaceURI().equals(string2) || !attribute.getName().equals(string)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean removeAttribute(String string) {
        return this.removeAttribute(string, Namespace.NO_NAMESPACE);
    }

    public boolean removeAttribute(String string, Namespace namespace) {
        if (this.attributes == null) {
            return false;
        }
        String string2 = namespace.getURI();
        Iterator iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (!attribute.getNamespaceURI().equals(string2) || !attribute.getName().equals(string)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer().append("[Element: <").append(this.getQualifiedName()).append(" />]");
        return stringBuffer.toString();
    }

    public final String getSerializedForm() {
        throw new RuntimeException("Element.getSerializedForm() is not yet implemented");
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final Object clone() {
        Object object;
        LinkedList linkedList;
        Element element = new Element(this.name, this.namespace);
        if (this.attributes != null) {
            linkedList = new LinkedList();
            object = this.attributes.iterator();
            while (object.hasNext()) {
                linkedList.add(((Attribute)object.next()).clone());
            }
            element.attributes = linkedList;
        }
        if (this.content != null) {
            linkedList = this.content.iterator();
            while (linkedList.hasNext()) {
                object = linkedList.next();
                if (object instanceof String) {
                    element.addContent((String)object);
                    continue;
                }
                if (object instanceof Comment) {
                    element.addContent((Comment)((Comment)object).clone());
                    continue;
                }
                if (object instanceof Entity) {
                    element.addContent((Entity)((Entity)object).clone());
                    continue;
                }
                if (object instanceof Element) {
                    element.addContent((Element)((Element)object).clone());
                    continue;
                }
                if (!(object instanceof CDATA)) continue;
                element.addContent((CDATA)((CDATA)object).clone());
            }
        }
        element.setParent(null);
        return element;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.namespace.getPrefix());
        objectOutputStream.writeObject(this.namespace.getURI());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.namespace = Namespace.getNamespace((String)objectInputStream.readObject(), (String)objectInputStream.readObject());
    }

    public String getContent(boolean bl) {
        if (bl) {
            return this.getText();
        }
        return this.getTextTrim();
    }

    public String getContent() {
        return this.getTextTrim();
    }

    public Element setContent(String string) {
        return this.setText(string);
    }

    public List getMixedContent(boolean bl) {
        PartialList partialList = new PartialList(this.content, this);
        if (bl) {
            partialList.addAllPartial((Collection)this.content);
        } else {
            Iterator iterator = this.content.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (object instanceof String) {
                    partialList.addPartial(((String)object).trim());
                    continue;
                }
                partialList.addPartial(object);
            }
        }
        return partialList;
    }

    public Element addChild(String string) {
        return this.addContent(string);
    }

    public Element addChild(Element element) {
        return this.addContent(element);
    }

    public Element addChild(ProcessingInstruction processingInstruction) {
        return this.addContent(processingInstruction);
    }

    public Element addChild(Entity entity) {
        return this.addContent(entity);
    }

    public Element addChild(Comment comment) {
        return this.addContent(comment);
    }

    public boolean removeChild(Element element) {
        return this.removeContent(element);
    }

    public boolean removeChild(ProcessingInstruction processingInstruction) {
        return this.removeContent(processingInstruction);
    }

    public boolean removeChild(Entity entity) {
        return this.removeContent(entity);
    }

    public boolean removeChild(Comment comment) {
        return this.removeContent(comment);
    }

    public boolean removeContent(Element element) {
        if (this.content == null) {
            return false;
        }
        if (this.content.remove((Object)element)) {
            element.setParent(null);
            return true;
        }
        return false;
    }

    public boolean removeContent(ProcessingInstruction processingInstruction) {
        if (this.content == null) {
            return false;
        }
        return this.content.remove((Object)processingInstruction);
    }

    public boolean removeContent(Entity entity) {
        if (this.content == null) {
            return false;
        }
        return this.content.remove((Object)entity);
    }

    public boolean removeContent(Comment comment) {
        if (this.content == null) {
            return false;
        }
        return this.content.remove((Object)comment);
    }
}

