/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.IllegalNameException;
import org.jdom.Verifier;

public final class Namespace {
    private static HashMap namespaces;
    private static HashMap mappings;
    public static final Namespace NO_NAMESPACE;
    public static final Namespace XML_NAMESPACE;
    private String prefix;
    private String uri;

    public static Namespace getNamespace(String string, String string2) {
        if (string == null || string.trim().equals("")) {
            string = "";
        }
        if (string2 == null || string2.trim().equals("")) {
            string2 = "";
        }
        if (string.equals("xml")) {
            return XML_NAMESPACE;
        }
        if (namespaces.containsKey((Object)string2)) {
            return (Namespace)namespaces.get((Object)string2);
        }
        String string3 = Verifier.checkNamespacePrefix(string);
        if (string3 != null) {
            throw new IllegalNameException(string, "Namespace prefix", string3);
        }
        string3 = Verifier.checkNamespaceURI(string2);
        if (string3 != null) {
            throw new IllegalNameException(string2, "Namespace URI", string3);
        }
        if (!string.equals("") && string2.equals("")) {
            throw new IllegalNameException("", "namespace", "Namespace URIs must be non-null and non-empty Strings.");
        }
        if (namespaces.containsKey((Object)string2)) {
            return (Namespace)namespaces.get((Object)(String.valueOf(string) + "&" + string2));
        }
        mappings.put((Object)string, (Object)string2);
        Namespace namespace = new Namespace(string, string2);
        namespaces.put((Object)(String.valueOf(string) + "&" + string2), (Object)namespace);
        return namespace;
    }

    public static Namespace getNamespace(String string) {
        return Namespace.getNamespace("", string);
    }

    public static Namespace getNamespace(String string, Element element) {
        if (element == null) {
            return null;
        }
        Namespace namespace = element.getNamespace();
        if (namespace.prefix.equals(string)) {
            return namespace;
        }
        List list = element.getAttributes();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            namespace = attribute.getNamespace();
            if (!namespace.prefix.equals(string)) continue;
            return namespace;
        }
        return Namespace.getNamespace(string, element.getParent());
    }

    private Namespace(String string, String string2) {
        this.prefix = string;
        this.uri = string2;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getURI() {
        return this.uri;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Namespace) {
            Namespace namespace = (Namespace)object;
            if (namespace.uri.equals(this.uri) && namespace.prefix.equals(this.prefix)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "[Namespace: prefix " + this.prefix + " is mapped to URI \"" + this.uri + "\"]";
    }

    public int hashCode() {
        return (String.valueOf(this.prefix) + this.uri).hashCode();
    }

    static {
        NO_NAMESPACE = new Namespace("", "");
        XML_NAMESPACE = new Namespace("xml", "http://www.w3.org/XML/1998/namespace");
        namespaces = new HashMap();
        mappings = new HashMap();
        namespaces.put((Object)"", (Object)NO_NAMESPACE);
        mappings.put((Object)"", (Object)"");
        mappings.put((Object)"xml", (Object)"http://www.w3.org/XML/1998/namespace");
        namespaces.put((Object)"xml&http://www.w3.org/XML/1998/namespace", (Object)XML_NAMESPACE);
    }
}

