/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.xerces.readers.DefaultEntityHandler;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.datatype.StateMessageDatatype;

public class ENTITYDatatypeValidator
extends AbstractDatatypeValidator {
    private DatatypeValidator fBaseValidator = null;
    private boolean fDerivedByList = false;
    private DefaultEntityHandler fEntityHandler = null;
    private StringPool fStringPool = null;
    public static final int ENTITY_INITIALIZE = 0;

    public ENTITYDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public ENTITYDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        this.setBasetype(datatypeValidator);
        this.fDerivedByList = bl;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    public int compare(String string, String string2) {
        return -1;
    }

    public Hashtable getFacets() {
        return null;
    }

    private void setBasetype(DatatypeValidator datatypeValidator) {
        this.fBaseValidator = datatypeValidator;
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        StateMessageDatatype stateMessageDatatype = (StateMessageDatatype)object;
        if (stateMessageDatatype != null && stateMessageDatatype.getDatatypeState() == 0) {
            Object[] objectArray = (Object[])stateMessageDatatype.getDatatypeObject();
            this.fEntityHandler = (DefaultEntityHandler)objectArray[0];
            this.fStringPool = (StringPool)objectArray[1];
        } else {
            if (this.fEntityHandler == null) {
                InvalidDatatypeValueException invalidDatatypeValueException = new InvalidDatatypeValueException("ERROR: ENTITYDatatype Validator: Failed Initialization DefaultEntityHandler is null");
                throw invalidDatatypeValueException;
            }
            if (this.fStringPool == null) {
                InvalidDatatypeValueException invalidDatatypeValueException = new InvalidDatatypeValueException("ERROR: ENTITYDatatype Validator: Failed Initialization StrinPool is null");
                throw invalidDatatypeValueException;
            }
            if (!this.fDerivedByList) {
                int n = this.fStringPool.addSymbol(string);
                if (!this.fEntityHandler.isUnparsedEntity(n)) {
                    InvalidDatatypeValueException invalidDatatypeValueException = new InvalidDatatypeValueException("ENTITY '" + string + "' is not valid");
                    invalidDatatypeValueException.setMinorCode(79);
                    invalidDatatypeValueException.setMajorCode(77);
                    throw invalidDatatypeValueException;
                }
            } else {
                String string2;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                StringBuffer stringBuffer = new StringBuffer(string.length());
                boolean bl = true;
                if (stringTokenizer.hasMoreTokens()) {
                    while (true) {
                        if (!this.fEntityHandler.isUnparsedEntity(this.fStringPool.addSymbol(string2 = stringTokenizer.nextToken()))) {
                            bl = false;
                        }
                        stringBuffer.append(string2);
                        if (!stringTokenizer.hasMoreTokens()) break;
                        stringBuffer.append(' ');
                    }
                }
                string2 = stringBuffer.toString();
                if (!bl || string2.length() == 0) {
                    InvalidDatatypeValueException invalidDatatypeValueException = new InvalidDatatypeValueException(string2);
                    invalidDatatypeValueException.setMinorCode(80);
                    invalidDatatypeValueException.setMajorCode(77);
                    throw invalidDatatypeValueException;
                }
            }
        }
        return null;
    }
}

