/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.contrib.input;

import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Map;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public class ResultSetBuilder {
    ResultSet rs;
    ResultSetMetaData rsmd;
    SQLException exception;
    Map names = new HashMap();
    Map attribs = new HashMap();
    Namespace ns = Namespace.NO_NAMESPACE;
    int maxRows = Integer.MAX_VALUE;
    String rootName = "result";
    String rowName = "entry";

    public ResultSetBuilder(ResultSet resultSet) {
        this.rs = resultSet;
        try {
            this.rsmd = resultSet.getMetaData();
            return;
        }
        catch (SQLException sQLException) {
            this.exception = sQLException;
            return;
        }
    }

    public Document build() throws JDOMException {
        if (this.exception != null) {
            throw new JDOMException("Database problem", (Throwable)this.exception);
        }
        try {
            int n = this.rsmd.getColumnCount();
            Element element = new Element(this.rootName, this.ns);
            Document document = new Document(element);
            int n2 = 0;
            while (this.rs.next() && n2++ < this.maxRows) {
                Element element2 = new Element(this.rowName, this.ns);
                int n3 = 1;
                while (n3 <= n) {
                    String string = this.rsmd.getColumnName(n3);
                    String string2 = this.lookupName(string);
                    String string3 = this.rs.getString(n3);
                    if (this.isAttribute(string)) {
                        if (!this.rs.wasNull()) {
                            element2.addAttribute(string2, string3);
                        }
                    } else {
                        Element element3 = new Element(string2, this.ns);
                        if (!this.rs.wasNull()) {
                            element3.setText(string3);
                        }
                        element2.addContent(element3);
                    }
                    ++n3;
                }
                element.addContent(element2);
            }
            return document;
        }
        catch (SQLException sQLException) {
            throw new JDOMException("Database problem", (Throwable)sQLException);
        }
    }

    private String lookupName(String string) {
        String string2 = (String)this.names.get((Object)string.toLowerCase());
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    private boolean isAttribute(String string) {
        Boolean bl = (Boolean)this.attribs.get((Object)string.toLowerCase());
        return bl == Boolean.TRUE;
    }

    public void setRootName(String string) {
        this.rootName = string;
    }

    public void setRowName(String string) {
        this.rowName = string;
    }

    public void setNamespace(Namespace namespace) {
        this.ns = namespace;
    }

    public void setMaxRows(int n) {
        this.maxRows = n;
    }

    public void setAsAttribute(String string) {
        this.attribs.put((Object)string.toLowerCase(), (Object)Boolean.TRUE);
    }

    public void setAsAttribute(String string, String string2) {
        this.attribs.put((Object)string.toLowerCase(), (Object)Boolean.TRUE);
        this.names.put((Object)string.toLowerCase(), (Object)string2);
    }

    public void setAsAttribute(int n) {
        try {
            String string = this.rsmd.getColumnName(n).toLowerCase();
            this.attribs.put((Object)string, (Object)Boolean.TRUE);
            return;
        }
        catch (SQLException sQLException) {
            this.exception = sQLException;
            return;
        }
    }

    public void setAsAttribute(int n, String string) {
        try {
            String string2 = this.rsmd.getColumnName(n).toLowerCase();
            this.attribs.put((Object)string2, (Object)Boolean.TRUE);
            this.names.put((Object)string2, (Object)string);
            return;
        }
        catch (SQLException sQLException) {
            this.exception = sQLException;
            return;
        }
    }

    public void setAsElement(String string, String string2) {
        String string3 = string.toLowerCase();
        this.attribs.put((Object)string3, (Object)Boolean.FALSE);
        this.names.put((Object)string3, (Object)string2);
    }

    public void setAsElement(int n, String string) {
        try {
            String string2 = this.rsmd.getColumnName(n).toLowerCase();
            this.attribs.put((Object)string2, (Object)Boolean.FALSE);
            this.names.put((Object)string2, (Object)string);
            return;
        }
        catch (SQLException sQLException) {
            this.exception = sQLException;
            return;
        }
    }
}

