/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.contrib.xpath.a;

import java.util.StringTokenizer;
import org.jdom.contrib.xpath.XPathParseException;
import org.jdom.contrib.xpath.a.ParseUtils;
import org.jdom.contrib.xpath.a.PoCPredicateParser;
import org.jdom.contrib.xpath.a.XPathHandler;
import org.jdom.contrib.xpath.a.XPathParser;
import org.jdom.contrib.xpath.a.XPathPredicateHandler;
import org.jdom.contrib.xpath.a.XPathPredicateParser;

public class PoCParser
implements XPathParser {
    private XPathHandler handler;
    private XPathPredicateParser predicateParser;

    public void setXPathHandler(XPathHandler xPathHandler) {
        this.handler = xPathHandler;
    }

    public XPathHandler getXPathHandler() {
        return this.handler;
    }

    public void parse(String string) throws XPathParseException {
        if (this.handler == null) {
            throw new XPathParseException("Must set a XPathHandler first.  See XPathParser.setXPathHandler(XPathHandler).");
        }
        try {
            this.handler.startParsingXPath();
            this.assertValidCharacters(string);
            this.parseWhole(string);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.handler.endParsingXPath();
            throw throwable;
        }
        Object var3_2 = null;
        this.handler.endParsingXPath();
    }

    public void setXPathPredicateParser(XPathPredicateParser xPathPredicateParser) {
        this.predicateParser = xPathPredicateParser;
    }

    public XPathPredicateParser getXPathPredicateParser() {
        return this.predicateParser;
    }

    protected void assertValidCharacters(String string) throws XPathParseException {
        if (string == null) {
            throw new XPathParseException("xpath cannot be null");
        }
        if ("".equals(string = string.trim())) {
            throw new XPathParseException("xpath cannot be empty");
        }
    }

    private void parseWhole(String string) throws XPathParseException {
        if (string.indexOf(124) == -1) {
            this.parseLocationPath(string);
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            this.parseLocationPath(stringTokenizer.nextToken());
        }
    }

    private void parseLocationPath(String string) throws XPathParseException {
        this.handler.startPath();
        string = string.trim();
        if (string.charAt(0) == '/') {
            this.handler.absolute();
            string = string.substring(1);
        }
        int n = string.indexOf(47);
        while (n != -1) {
            if (n == 0) {
                this.parseStep(null);
            } else {
                this.parseStep(string.substring(0, n));
            }
            string = string.substring(n + 1);
            n = string.indexOf(47);
        }
        this.parseStep(string);
        this.handler.endPath();
    }

    private void parseStep(String string) throws XPathParseException {
        this.handler.startStep();
        if (string != null) {
            int n = (string = string.trim()).indexOf(91);
            if (n == -1) {
                this.parseNodeTest(string);
            } else {
                this.parseNodeTest(string.substring(0, n));
                this.parsePredicates(string.substring(n));
            }
        }
        this.handler.endStep();
    }

    private void parseNodeTest(String string) throws XPathParseException {
        int n;
        int n2 = string.indexOf("::");
        String string2 = null;
        if (n2 != -1) {
            string2 = string.substring(0, n2);
            string = string.substring(n2 + 2, string.length());
        }
        if ((n = string.indexOf(40)) == -1) {
            int n3 = string.indexOf(58);
            if (n3 == -1) {
                this.handler.nametest(string2, null, string);
                return;
            }
            this.handler.nametest(string2, string.substring(0, n3), string.substring(n3 + 1));
            return;
        }
        int n4 = string.indexOf(41);
        if (n4 == -1) {
            throw new XPathParseException("Closing parenthesis expected: " + string);
        }
        if (n4 < n) {
            throw new XPathParseException("Closing parenthesis found before opening: " + string);
        }
        this.handler.nodetype(string2, string.substring(0, n), ParseUtils.extractLiteral(string.substring(n + 1, n4)));
    }

    private void parsePredicates(String string) throws XPathParseException {
        int n = string.indexOf(91);
        while (n != -1) {
            int n2 = string.indexOf(93);
            this.parsePredicate(string.substring(n + 1, n2));
            string = string.substring(n2 + 1);
            n = string.indexOf(91);
        }
    }

    private void parsePredicate(String string) throws XPathParseException {
        XPathPredicateHandler xPathPredicateHandler = this.handler.startXPathPredicate();
        if (this.predicateParser == null) {
            this.predicateParser = new PoCPredicateParser();
        }
        if (this.predicateParser.getXPathParser() == null) {
            this.predicateParser.setXPathParser(this);
        }
        this.predicateParser.setXPathPredicateHandler(xPathPredicateHandler);
        this.predicateParser.parsePredicate(string);
        this.handler.endXPathPredicate(xPathPredicateHandler);
    }
}

