/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.contrib.input;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public class ResultSetBuilder {
    ResultSet rs;
    ResultSetMetaData rsmd;
    SQLException exception = null;
    Map names = new HashMap();
    Map attribs = new HashMap();
    Namespace ns = Namespace.NO_NAMESPACE;
    int maxRows = Integer.MAX_VALUE;
    String rootName = "result";
    String rowName = "entry";

    public ResultSetBuilder(ResultSet rs) {
        this.rs = rs;
        try {
            this.rsmd = rs.getMetaData();
        }
        catch (SQLException e) {
            this.exception = e;
        }
    }

    public Document build() throws JDOMException {
        if (this.exception != null) {
            throw new JDOMException("Database problem", (Throwable)this.exception);
        }
        try {
            int colCount = this.rsmd.getColumnCount();
            Element root = new Element(this.rootName, this.ns);
            Document doc = new Document(root);
            int rowCount = 0;
            while (this.rs.next() && rowCount++ < this.maxRows) {
                Element entry = new Element(this.rowName, this.ns);
                int col = 1;
                while (col <= colCount) {
                    String origName = this.rsmd.getColumnName(col);
                    String name = this.lookupName(origName);
                    String value = this.rs.getString(col);
                    if (this.isAttribute(origName)) {
                        if (!this.rs.wasNull()) {
                            entry.addAttribute(name, value);
                        }
                    } else {
                        Element child = new Element(name, this.ns);
                        if (!this.rs.wasNull()) {
                            child.setText(value);
                        }
                        entry.addContent(child);
                    }
                    ++col;
                }
                root.addContent(entry);
            }
            return doc;
        }
        catch (SQLException e) {
            throw new JDOMException("Database problem", (Throwable)e);
        }
    }

    private boolean isAttribute(String origName) {
        Boolean val = (Boolean)this.attribs.get(origName.toLowerCase());
        return val == Boolean.TRUE;
    }

    private String lookupName(String origName) {
        String name = (String)this.names.get(origName.toLowerCase());
        if (name != null) {
            return name;
        }
        return origName;
    }

    public void setAsAttribute(int columnNum) {
        try {
            String name = this.rsmd.getColumnName(columnNum).toLowerCase();
            this.attribs.put(name, Boolean.TRUE);
        }
        catch (SQLException e) {
            this.exception = e;
        }
    }

    public void setAsAttribute(int columnNum, String attribName) {
        try {
            String name = this.rsmd.getColumnName(columnNum).toLowerCase();
            this.attribs.put(name, Boolean.TRUE);
            this.names.put(name, attribName);
        }
        catch (SQLException e) {
            this.exception = e;
        }
    }

    public void setAsAttribute(String columnName) {
        this.attribs.put(columnName.toLowerCase(), Boolean.TRUE);
    }

    public void setAsAttribute(String columnName, String attribName) {
        this.attribs.put(columnName.toLowerCase(), Boolean.TRUE);
        this.names.put(columnName.toLowerCase(), attribName);
    }

    public void setAsElement(int columnNum, String elemName) {
        try {
            String name = this.rsmd.getColumnName(columnNum).toLowerCase();
            this.attribs.put(name, Boolean.FALSE);
            this.names.put(name, elemName);
        }
        catch (SQLException e) {
            this.exception = e;
        }
    }

    public void setAsElement(String columnName, String elemName) {
        String name = columnName.toLowerCase();
        this.attribs.put(name, Boolean.FALSE);
        this.names.put(name, elemName);
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public void setNamespace(Namespace ns) {
        this.ns = ns;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    public void setRowName(String rowName) {
        this.rowName = rowName;
    }
}

