/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.Browsers;
import org.apache.cocoon.Cocoon;
import org.apache.cocoon.Defaults;
import org.apache.cocoon.Frontend;
import org.apache.cocoon.cache.Cache;
import org.apache.cocoon.formatter.Formatter;
import org.apache.cocoon.formatter.FormatterFactory;
import org.apache.cocoon.framework.Configurations;
import org.apache.cocoon.framework.Manager;
import org.apache.cocoon.framework.Page;
import org.apache.cocoon.framework.Status;
import org.apache.cocoon.interpreter.InterpreterFactory;
import org.apache.cocoon.logger.Logger;
import org.apache.cocoon.logger.ServletLogger;
import org.apache.cocoon.logger.StdioLogger;
import org.apache.cocoon.parser.Parser;
import org.apache.cocoon.processor.Processor;
import org.apache.cocoon.processor.ProcessorFactory;
import org.apache.cocoon.producer.Producer;
import org.apache.cocoon.producer.ProducerFactory;
import org.apache.cocoon.store.Store;
import org.apache.cocoon.transformer.Transformer;
import org.w3c.dom.Document;

public class Engine
implements Defaults {
    private static Hashtable engineInstances = new Hashtable(1, 0.9f);
    Configurations configurations;
    boolean showStatus;
    ProducerFactory producers;
    ProcessorFactory processors;
    FormatterFactory formatters;
    InterpreterFactory interpreters;
    Manager manager = new Manager();
    Browsers browsers;
    Parser parser;
    Transformer transformer;
    Cache cache;
    Store store;
    Logger logger;
    ServletContext servletContext;
    static /* synthetic */ Class class$org$apache$cocoon$Engine;

    private Engine(Configurations configurations, Object context) throws Exception {
        this.manager.setRole("factory", this.manager);
        this.configurations = configurations;
        if (context == null) {
            this.logger = new StdioLogger((String)configurations.get("log.level"));
            this.manager.setRole("logger", this.logger);
        } else if (context instanceof ServletContext) {
            this.servletContext = (ServletContext)context;
            this.manager.setRole("context", context);
            this.logger = new ServletLogger(this.servletContext, (String)configurations.get("log.level"));
            this.manager.setRole("logger", this.logger);
        }
        this.parser = (Parser)this.manager.create((String)configurations.get("parser", "org.apache.cocoon.parser.XercesParser"), configurations.getConfigurations("parser"));
        this.manager.setRole("parser", this.parser);
        this.transformer = (Transformer)this.manager.create((String)configurations.get("transformer", "org.apache.cocoon.transformer.XalanTransformer"), configurations.getConfigurations("transformer"));
        this.manager.setRole("transformer", this.transformer);
        this.store = (Store)this.manager.create((String)configurations.get("store", "org.apache.cocoon.store.CocoonStore"), configurations.getConfigurations("store"));
        this.manager.setRole("store", this.store);
        this.cache = (Cache)this.manager.create((String)configurations.get("cache", "org.apache.cocoon.cache.CocoonCache"), configurations.getConfigurations("cache"));
        this.manager.setRole("cache", this.cache);
        this.interpreters = (InterpreterFactory)this.manager.create("org.apache.cocoon.interpreter.InterpreterFactory", configurations.getConfigurations("interpreter"));
        this.manager.setRole("interpreters", this.interpreters);
        this.producers = (ProducerFactory)this.manager.create("org.apache.cocoon.producer.ProducerFactory", configurations.getConfigurations("producer"));
        this.manager.setRole("producers", this.producers);
        this.processors = (ProcessorFactory)this.manager.create("org.apache.cocoon.processor.ProcessorFactory", configurations.getConfigurations("processor"));
        this.manager.setRole("processors", this.processors);
        this.formatters = (FormatterFactory)this.manager.create("org.apache.cocoon.formatter.FormatterFactory", configurations.getConfigurations("formatter"));
        this.manager.setRole("formatters", this.formatters);
        this.browsers = (Browsers)this.manager.create("org.apache.cocoon.Browsers", configurations.getConfigurations("browser"));
        this.manager.setRole("browsers", this.browsers);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private boolean getFlag(HttpServletRequest request, String name, boolean normal) {
        String flag = request.getParameter(name);
        return flag != null ? flag.toLowerCase().equals("true") : normal;
    }

    public static Engine getInstance() throws Exception {
        if (!engineInstances.isEmpty()) {
            return (Engine)engineInstances.elements().nextElement();
        }
        throw new Exception("The Cocoon engine has not been initialized!");
    }

    public static Engine getInstance(Configurations confs, Object context) throws Exception {
        Engine engine = (Engine)engineInstances.get(context);
        if (engine == null) {
            Class clazz = class$org$apache$cocoon$Engine != null ? class$org$apache$cocoon$Engine : (class$org$apache$cocoon$Engine = Engine.class$("org.apache.cocoon.Engine"));
            synchronized (clazz) {
                engine = new Engine(confs, context);
                engineInstances.put(context, engine);
            }
        }
        return engine;
    }

    public Hashtable getStatus() {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("Browsers", this.browsers.getStatus());
        Enumeration e = this.manager.getRoles();
        while (e.hasMoreElements()) {
            String role = (String)e.nextElement();
            Object actor = this.manager.getActor(role);
            StringBuffer roleBuffer = new StringBuffer(role);
            if (roleBuffer.length() > 0) {
                roleBuffer.setCharAt(0, Character.toUpperCase(roleBuffer.charAt(0)));
            }
            String formattedRole = roleBuffer.toString();
            if (actor instanceof Status) {
                table.put(formattedRole, ((Status)actor).getStatus());
                continue;
            }
            table.put(formattedRole, actor.getClass().getName());
        }
        return table;
    }

    public void handle(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.logger.log(this, "Starting request", 4);
        long time = 0L;
        time = System.currentTimeMillis();
        ByteArrayOutputStream debugStream = null;
        boolean CACHE = this.getFlag(request, "cache", true);
        boolean DEBUG = this.getFlag(request, "debug", false);
        String agent = request.getParameter("user-Agent");
        if (agent == null) {
            agent = request.getHeader("user-Agent");
        }
        if (DEBUG) {
            debugStream = new ByteArrayOutputStream();
            PrintStream stream = new PrintStream(new BufferedOutputStream(debugStream), true);
            System.setOut(stream);
            System.setErr(stream);
        }
        Page page = null;
        if (CACHE) {
            page = this.cache.getPage(request);
        }
        if (page == null) {
            this.logger.log(this, "Creating page", 5);
            int i = 0;
            while (i < 10) {
                try {
                    Processor processor;
                    page = new Page();
                    Producer producer = this.producers.getProducer(request);
                    page.setChangeable(producer);
                    Document document = producer.getDocument(request);
                    this.logger.log(this, "Document produced", 5);
                    Hashtable<String, String> environment = new Hashtable<String, String>();
                    environment.put("path", producer.getPath(request));
                    environment.put("browser", this.browsers.map(agent));
                    environment.put("request", (String)request);
                    environment.put("response", (String)response);
                    environment.put("context", (String)this.servletContext);
                    while ((processor = this.processors.getProcessor(document)) != null) {
                        document = processor.process(document, environment);
                        page.setChangeable(processor);
                        this.logger.log(this, "Document processed", 5);
                    }
                    Formatter formatter = this.formatters.getFormatter(document);
                    StringWriter writer = new StringWriter();
                    formatter.format(document, writer, environment);
                    this.logger.log(this, "Document formatted", 5);
                    page.setContent(writer.toString());
                    String encoding = formatter.getEncoding();
                    if (encoding != null) {
                        page.setContentType(String.valueOf(formatter.getMIMEType()) + "; charset=" + encoding);
                        break;
                    }
                    page.setContentType(formatter.getMIMEType());
                    break;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    this.logger.log(this, "Triggered OutOfMemory", 3);
                    this.cache.flush();
                    page = null;
                    ++i;
                }
            }
        }
        if (page == null) {
            this.logger.log(this, "System is out of memory", 0);
            throw new Exception("FATAL ERROR: the system ran out of memory when processing the request. Increase your JVM memory.");
        }
        if (DEBUG) {
            Frontend.print((ServletResponse)response, "Debugging " + request.getRequestURI(), debugStream.toString());
            System.setOut(System.out);
            System.setErr(System.err);
        } else {
            response.setContentType(page.getContentType());
            PrintWriter out = response.getWriter();
            out.println(page.getContent());
            if (page.isText()) {
                time = System.currentTimeMillis() - time;
                out.println("<!-- This page was served " + (page.isCached() ? "from cache " : "") + "in " + time + " milliseconds by " + Cocoon.version() + " -->");
            }
            out.flush();
        }
        this.logger.log(this, "response sent to client", 3);
        this.cache.setPage(page, request);
    }
}

