/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.interpreter.ecmascript;

import FESI.jslib.JSGlobalObject;
import FESI.jslib.JSUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Dictionary;
import java.util.Vector;
import org.apache.cocoon.interpreter.Instance;
import org.apache.cocoon.interpreter.LanguageException;
import org.apache.cocoon.interpreter.Module;
import org.apache.cocoon.interpreter.ecmascript.EcmaScriptEvaluator;
import org.apache.cocoon.interpreter.ecmascript.EcmaScriptInstance;
import org.w3c.dom.Document;

public class EcmaScriptModule
implements Module {
    private static String[] extensions = new String[]{"FESI.Extensions.BasicIO", "FESI.Extensions.FileIO", "FESI.Extensions.JavaAccess", "FESI.Extensions.Database", "FESI.Extensions.OptionalRegExp"};
    private static String initScript = null;
    private static URL url = null;
    private static final String INIT_SCRIPT = "initScript.es";
    long lastModified;
    private File scriptFile = null;
    private String scriptName;
    private String scriptText;
    private Vector evaluatorPool;
    private JSGlobalObject globalEvaluator;
    static /* synthetic */ Class class$org$apache$cocoon$interpreter$ecmascript$EcmaScriptModule;

    public EcmaScriptModule(String theModule) throws LanguageException {
        this.scriptName = theModule;
        try {
            if (initScript == null) {
                initScript = EcmaScriptModule.getFileContents((class$org$apache$cocoon$interpreter$ecmascript$EcmaScriptModule != null ? class$org$apache$cocoon$interpreter$ecmascript$EcmaScriptModule : (class$org$apache$cocoon$interpreter$ecmascript$EcmaScriptModule = EcmaScriptModule.class$("org.apache.cocoon.interpreter.ecmascript.EcmaScriptModule"))).getResourceAsStream(INIT_SCRIPT));
            }
        }
        catch (Exception e) {
            throw new LanguageException("Could not find ECMAScript initialization file. The archive is probably damaged: " + e.toString());
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Instance createInstance(Document document, Dictionary parameters) throws LanguageException {
        try {
            if (this.scriptFile == null) {
                String path = (String)parameters.get("path");
                if (path != null) {
                    this.scriptName = String.valueOf(path) + this.scriptName;
                }
                this.scriptFile = new File(this.scriptName);
                this.lastModified = this.scriptFile.lastModified();
                if (!this.scriptFile.canRead()) {
                    throw new LanguageException("Can't open file " + this.scriptName);
                }
                this.loadScript();
            }
            if (this.scriptFile.lastModified() != this.lastModified) {
                this.loadScript();
                this.lastModified = this.scriptFile.lastModified();
            }
            EcmaScriptEvaluator requestEvaluator = null;
            int poolSize = this.evaluatorPool.size();
            int count = 0;
            while (count < poolSize) {
                requestEvaluator = (EcmaScriptEvaluator)this.evaluatorPool.elementAt(count);
                if (requestEvaluator.acquire()) break;
                ++count;
            }
            if (count == poolSize) {
                requestEvaluator = new EcmaScriptEvaluator(this.globalEvaluator, extensions);
                requestEvaluator.acquire();
                this.evaluatorPool.addElement(requestEvaluator);
            }
            JSGlobalObject globalObject = requestEvaluator.getGlobalObject();
            globalObject.setMember("global", (Object)globalObject.makeObjectWrapper((Object)this.globalEvaluator));
            Object request = parameters.get("request");
            globalObject.setMember("request", (Object)globalObject.makeObjectWrapper(request));
            globalObject.setMember("document", (Object)globalObject.makeObjectWrapper((Object)document));
            System.out.println("Ending...");
            return new EcmaScriptInstance(requestEvaluator, document);
        }
        catch (Exception e) {
            throw new LanguageException(e.getMessage());
        }
    }

    private static String getFileContents(InputStream inputStream) throws IOException {
        int len;
        InputStreamReader reader = new InputStreamReader(inputStream);
        char[] chr = new char[4096];
        StringBuffer buffer = new StringBuffer();
        while ((len = reader.read(chr)) > 0) {
            buffer.append(chr, 0, len);
        }
        return buffer.toString();
    }

    private static String getFileContents(String fileName) throws IOException {
        return EcmaScriptModule.getFileContents(new FileInputStream(fileName));
    }

    private void loadScript() throws LanguageException {
        try {
            this.globalEvaluator = JSUtil.makeEvaluator((String[])extensions);
            this.scriptText = EcmaScriptModule.getFileContents(this.scriptName);
            this.globalEvaluator.eval(initScript);
            this.globalEvaluator.eval(this.scriptText);
            this.evaluatorPool = new Vector();
            this.evaluatorPool.addElement(new EcmaScriptEvaluator(this.globalEvaluator, extensions));
        }
        catch (Exception e) {
            throw new LanguageException("Error creating EcmaScript evaluator: " + e.getMessage());
        }
    }
}

