/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class ConnectionCreator {
    protected String dburl;
    protected String username;
    protected String password;
    protected int loginTimeout = -1;

    public ConnectionCreator(Properties props) {
        this.dburl = props.getProperty("dburl");
        this.username = props.getProperty("username");
        this.password = props.getProperty("password");
        this.loginTimeout = Integer.parseInt(props.getProperty("login-timeout", "-1"));
    }

    public Connection getConnection() throws SQLException {
        Connection retval = null;
        int oldLoginTimeout = -1;
        if (this.loginTimeout >= 0) {
            oldLoginTimeout = DriverManager.getLoginTimeout();
            DriverManager.setLoginTimeout(this.loginTimeout);
        }
        retval = this.username != null && this.password != null ? DriverManager.getConnection(this.dburl, this.username, this.password) : DriverManager.getConnection(this.dburl);
        if (this.loginTimeout >= 0) {
            DriverManager.setLoginTimeout(oldLoginTimeout);
        }
        return retval;
    }
}

