/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.sql;

import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.framework.AbstractActor;
import org.apache.cocoon.framework.Status;
import org.apache.cocoon.processor.Processor;
import org.apache.cocoon.processor.sql.Column;
import org.apache.cocoon.processor.sql.ColumnFormatter;
import org.apache.cocoon.processor.sql.ConnectionDefs;
import org.apache.cocoon.processor.sql.DefaultQueryCreator;
import org.apache.cocoon.processor.sql.QueryCreator;
import org.apache.cocoon.processor.sql.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SQLProcessor
extends AbstractActor
implements Processor,
Status {
    protected static Hashtable drivers = new Hashtable();
    protected static Hashtable query_creators = new Hashtable();
    protected static QueryCreator default_query_creator = new DefaultQueryCreator();
    protected static final int OMIT_NULLS = 0;
    protected static final int ATTRIBUTE_NULLS = 1;

    protected Column[] getColumns(ResultSetMetaData md, String tag_case) throws SQLException {
        Column[] columns;
        block4: {
            block5: {
                block3: {
                    columns = new Column[md.getColumnCount()];
                    if (!tag_case.equals("preserve")) break block3;
                    int i = 0;
                    while (i < columns.length) {
                        columns[i] = new Column(md.getColumnName(i + 1), md.getColumnTypeName(i + 1));
                        ++i;
                    }
                    break block4;
                }
                if (!tag_case.equals("lower")) break block5;
                int i = 0;
                while (i < columns.length) {
                    columns[i] = new Column(md.getColumnName(i + 1).toLowerCase(), md.getColumnTypeName(i + 1));
                    ++i;
                }
                break block4;
            }
            if (!tag_case.equals("upper")) break block4;
            int i = 0;
            while (i < columns.length) {
                columns[i] = new Column(md.getColumnName(i + 1).toUpperCase(), md.getColumnTypeName(i + 1));
                ++i;
            }
        }
        return columns;
    }

    public static String getCountQuery(String query) {
        String lowercase_query = query.toLowerCase();
        int select_index = lowercase_query.indexOf("select ");
        int from_index = lowercase_query.indexOf(" from ");
        if (select_index < 0 || from_index < 0) {
            return null;
        }
        String columns = query.substring(select_index + 7, from_index);
        int comma_index = columns.indexOf(44);
        String column = comma_index < 0 ? columns : columns.substring(0, comma_index);
        return "SELECT count(" + column + ") FROM " + query.substring(from_index + 6);
    }

    protected static int getIntProperty(Properties props, String name, int def) {
        String value = props.getProperty(name);
        if (value == null) {
            return def;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public String getStatus() {
        return "SQL Processor";
    }

    public boolean hasChanged(Object context) {
        return true;
    }

    public Document process(Document document, Dictionary parameters) throws Exception {
        HttpServletRequest request = (HttpServletRequest)parameters.get("request");
        try {
            ConnectionDefs cdefs = new ConnectionDefs(document);
            NodeList query_nodes = document.getElementsByTagName("query");
            Node[] query_nodes_ary = new Node[query_nodes.getLength()];
            int i = 0;
            while (i < query_nodes.getLength()) {
                query_nodes_ary[i] = query_nodes.item(i);
                ++i;
            }
            int i2 = 0;
            while (i2 < query_nodes_ary.length) {
                Node query_node = query_nodes_ary[i2];
                if (query_node.getNodeType() == 1) {
                    Element query_element = (Element)query_node;
                    String defs = query_element.getAttribute("defs");
                    Properties query_props = cdefs.getQueryProperties(defs);
                    NamedNodeMap query_attributes = query_element.getAttributes();
                    int j = 0;
                    while (j < query_attributes.getLength()) {
                        Node query_attribute = query_attributes.item(j);
                        ((Hashtable)query_props).put(query_attribute.getNodeName(), query_attribute.getNodeValue());
                        ++j;
                    }
                    NodeList child_list = query_element.getChildNodes();
                    int j2 = 0;
                    while (j2 < child_list.getLength()) {
                        Node child_node = child_list.item(j2);
                        if (child_node.getNodeName().equals("request") && child_node.getNodeType() == 1) {
                            Element request_element = (Element)child_node;
                            NamedNodeMap request_attributes = request_element.getAttributes();
                            int k = 0;
                            while (k < request_attributes.getLength()) {
                                String value;
                                Node request_attribute = request_attributes.item(k);
                                String attr_name = request_attribute.getNodeName();
                                String req_name = request_attribute.getNodeValue();
                                if (req_name.equals("")) {
                                    req_name = attr_name;
                                }
                                if ((value = request.getParameter(req_name)) == null) {
                                    value = "";
                                }
                                ((Hashtable)query_props).put(attr_name, value);
                                ++k;
                            }
                        }
                        ++j2;
                    }
                    Connection conn = cdefs.getConnection(query_props.getProperty("connection"));
                    this.processQuery(document, parameters, query_element, query_props, conn);
                }
                ++i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    protected void processQuery(Document document, Dictionary parameters, Element query_element, Properties query_props, Connection conn) throws Exception {
        boolean auto_commit = conn.getAutoCommit();
        HttpServletRequest req = (HttpServletRequest)parameters.get("request");
        String doc_element_name = query_props.getProperty("doc-element");
        String row_element_name = query_props.getProperty("row-element");
        boolean create_row_elements = true;
        if (row_element_name.equals("")) {
            create_row_elements = false;
        }
        int max_rows = SQLProcessor.getIntProperty(query_props, "max-rows", -1);
        int skip_rows = SQLProcessor.getIntProperty(query_props, "skip-rows", 0);
        String id_attribute = query_props.getProperty("id-attribute");
        boolean create_id_attribute = true;
        if (id_attribute.equals("")) {
            create_id_attribute = false;
        }
        String id_attribute_column = query_props.getProperty("id-attribute-column");
        String null_indicator = query_props.getProperty("null-indicator");
        String tag_case = query_props.getProperty("tag-case");
        String query_creator_name = query_props.getProperty("creator");
        String count_attribute = query_props.getProperty("count-attribute");
        String query_attribute = query_props.getProperty("query-attribute");
        String skip_rows_attribute = query_props.getProperty("skip-rows-attribute");
        String max_rows_attribute = query_props.getProperty("max-rows-attribute");
        String update_rows_attribute = query_props.getProperty("update-rows-attribute");
        String query = query_props.getProperty("query");
        String namespace = query_props.getProperty("namespace");
        SimpleDateFormat timestamp_format = null;
        String timestamp_format_string = query_props.getProperty("timestamp_format");
        if (timestamp_format_string != null) {
            timestamp_format = new SimpleDateFormat(timestamp_format_string);
        }
        try {
            block43: {
                try {
                    ResultSet rs;
                    Node results_node;
                    if (query == null || query.equals("")) {
                        QueryCreator query_creator;
                        if (query_creator_name != null) {
                            if (query_creators.containsKey(query_creator_name)) {
                                query_creator = (QueryCreator)query_creators.get(query_creator_name);
                            } else {
                                query_creator = (QueryCreator)Class.forName(query_creator_name).newInstance();
                                query_creators.put(query_creator_name, query_creator);
                            }
                        } else {
                            query_creator = default_query_creator;
                        }
                        NodeList query_text_nodes = query_element.getChildNodes();
                        StringBuffer query_buffer = new StringBuffer();
                        int i = 0;
                        while (i < query_text_nodes.getLength()) {
                            Node query_text_node = query_text_nodes.item(i);
                            if (query_text_node.getNodeType() == 3) {
                                query_buffer.append(query_text_node.getNodeValue());
                            }
                            ++i;
                        }
                        query = query_creator.getQuery(conn, query_buffer.toString(), query_element, query_props, parameters);
                    }
                    Statement st = conn.createStatement();
                    Element results_element = null;
                    if (doc_element_name.equals("")) {
                        results_node = document.createDocumentFragment();
                    } else {
                        String count_query;
                        results_element = Utils.createElement(document, namespace, doc_element_name);
                        results_node = results_element;
                        if (!count_attribute.equals("") && (count_query = SQLProcessor.getCountQuery(query)) != null) {
                            rs = st.executeQuery(count_query);
                            if (rs.next()) {
                                results_element.setAttribute(count_attribute, rs.getString(1));
                            }
                            rs.close();
                        }
                        if (!query_attribute.equals("")) {
                            results_element.setAttribute(query_attribute, URLEncoder.encode(query));
                        }
                        if (!skip_rows_attribute.equals("")) {
                            results_element.setAttribute(skip_rows_attribute, String.valueOf(skip_rows));
                        }
                        if (!max_rows_attribute.equals("")) {
                            results_element.setAttribute(max_rows_attribute, String.valueOf(max_rows));
                        }
                    }
                    if (!update_rows_attribute.equals("")) {
                        int update_rows = st.executeUpdate(query);
                        if (results_element != null) {
                            results_element.setAttribute(update_rows_attribute, String.valueOf(update_rows));
                        }
                    } else {
                        rs = st.executeQuery(query);
                        ResultSetMetaData md = rs.getMetaData();
                        Column[] columns = this.getColumns(md, tag_case);
                        int id_attribute_column_index = -1;
                        if (create_id_attribute) {
                            int i = 0;
                            while (i < columns.length) {
                                if (columns[i].name.equals(id_attribute_column)) {
                                    id_attribute_column_index = i;
                                }
                                ++i;
                            }
                        }
                        boolean null_mode = false;
                        if (null_indicator.equals("y")) {
                            null_mode = true;
                        } else if (null_indicator.equals("yes")) {
                            null_mode = true;
                        }
                        Node row_node = results_node;
                        Element row_element = null;
                        int count = 0;
                        if (skip_rows > 0) {
                            while (rs.next()) {
                                if (++count != skip_rows) continue;
                            }
                        }
                        ColumnFormatter formatter = new ColumnFormatter(query_element);
                        while (rs.next()) {
                            if (create_row_elements) {
                                row_element = Utils.createElement(document, namespace, row_element_name);
                                row_node = row_element;
                                if (create_id_attribute && id_attribute_column_index == -1) {
                                    row_element.setAttribute(id_attribute, String.valueOf(count));
                                }
                            }
                            int i = 0;
                            while (i < columns.length) {
                                Object value = rs.getObject(i + 1);
                                if (create_row_elements && create_id_attribute && id_attribute_column_index == i) {
                                    row_element.setAttribute(id_attribute, ColumnFormatter.getStringValue(value));
                                } else if (value != null || null_mode) {
                                    Element column_element = Utils.createElement(document, namespace, columns[i].name);
                                    if (value == null && null_mode) {
                                        column_element.setAttribute("NULL", "YES");
                                        column_element.appendChild(document.createTextNode(""));
                                    } else {
                                        formatter.addColumnNode(document, column_element, columns[i], value, i + 1);
                                    }
                                    row_node.appendChild(column_element);
                                }
                                ++i;
                            }
                            if (create_row_elements) {
                                results_node.appendChild(row_node);
                            }
                            if (count - skip_rows == max_rows - 1) break;
                            ++count;
                        }
                        rs.close();
                    }
                    st.close();
                    if (!auto_commit) {
                        conn.commit();
                    }
                    query_element.getParentNode().replaceChild(results_node, query_element);
                }
                catch (Exception e) {
                    Element error_element = Utils.createErrorElement(document, namespace, query_props, e);
                    query_element.getParentNode().replaceChild(error_element, query_element);
                    if (auto_commit) break block43;
                    conn.rollback();
                }
            }
            Object var29_47 = null;
        }
        catch (Throwable throwable) {
            Object var29_48 = null;
            conn.close();
            throw throwable;
        }
        conn.close();
    }
}

