/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.xsp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.Tokenizer;
import org.apache.cocoon.Utils;
import org.apache.cocoon.framework.AbstractActor;
import org.apache.cocoon.framework.Configurable;
import org.apache.cocoon.framework.Configurations;
import org.apache.cocoon.framework.Director;
import org.apache.cocoon.framework.Factory;
import org.apache.cocoon.framework.Monitor;
import org.apache.cocoon.framework.Status;
import org.apache.cocoon.logger.Logger;
import org.apache.cocoon.parser.Parser;
import org.apache.cocoon.processor.Processor;
import org.apache.cocoon.processor.ProcessorException;
import org.apache.cocoon.processor.xsp.XSPGlobal;
import org.apache.cocoon.processor.xsp.XSPLogicsheet;
import org.apache.cocoon.processor.xsp.XSPPage;
import org.apache.cocoon.processor.xsp.XSPUtil;
import org.apache.cocoon.processor.xsp.language.XSPLanguageProcessor;
import org.apache.cocoon.processor.xsp.language.XSPPreprocessor;
import org.apache.cocoon.store.Store;
import org.apache.cocoon.transformer.Transformer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XSPProcessor
extends AbstractActor
implements Processor,
Configurable,
Status {
    public static final String DEFAULT_LANGUAGE = "java";
    public static final String LOGICSHEET_PI = "xml-logicsheet";
    protected Factory factory;
    protected Parser parser;
    protected Transformer transformer;
    protected Hashtable languages;
    protected File repositoryFile;
    protected String encoding;
    protected Store store;
    protected Monitor monitor;
    protected Hashtable byNamespace;
    protected Logger logger;
    protected XSPGlobal global = new XSPGlobal();
    protected ServletContext servletContext;

    private Document getDocument(Object resource) throws Exception {
        InputSource input = new InputSource();
        input.setSystemId(resource.toString());
        if (resource instanceof File) {
            input.setCharacterStream(new FileReader((File)resource));
        } else if (resource instanceof URL) {
            input.setCharacterStream(new InputStreamReader(((URL)resource).openStream()));
        } else {
            throw new Error("Fatal error: Could not elaborate given resource: " + resource);
        }
        return this.parser.parse(input, false);
    }

    protected XSPGlobal getGlobal() {
        return this.global;
    }

    private Vector getLogicsheets(Document document, HttpServletRequest request) throws Exception {
        Vector<Object> vector = new Vector<Object>();
        Enumeration pis = Utils.getAllPIs(document, LOGICSHEET_PI).elements();
        while (pis.hasMoreElements()) {
            Hashtable attributes = Utils.getPIPseudoAttributes((ProcessingInstruction)pis.nextElement());
            String location = (String)attributes.get("href");
            if (location == null) continue;
            try {
                XSPPreprocessor preprocessor = null;
                String preprocessorName = (String)attributes.get("dom-preprocessor");
                if (preprocessorName != null) {
                    preprocessor = (XSPPreprocessor)Class.forName(preprocessorName).newInstance();
                }
                Object resource = Utils.getLocationResource(location, request, this.servletContext);
                this.refreshLogicsheet(resource, preprocessor);
                vector.addElement(resource);
            }
            catch (MalformedURLException malformedURLException) {
                throw new ProcessorException("Could not associate logicsheet to document: " + location + " is a malformed URL.");
            }
        }
        return vector;
    }

    protected ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getStatus() {
        return "eXtensible Server Pages Processor";
    }

    public boolean hasChanged(Object context) {
        if (!(context instanceof HttpServletRequest)) {
            return true;
        }
        HttpServletRequest request = (HttpServletRequest)context;
        String filename = Utils.getBasename(request, this.servletContext);
        PageEntry pageEntry = (PageEntry)this.store.get(filename);
        if (pageEntry == null) {
            return true;
        }
        return pageEntry.getPage().hasChanged(context);
    }

    public void init(Configurations conf) {
        Hashtable<String, XSPLogicsheet> xspLogicsheets = new Hashtable<String, XSPLogicsheet>(10);
        this.encoding = (String)conf.get("encoding");
        Tokenizer t = new Tokenizer((String)conf.get("languages"));
        while (t.hasMoreTokens()) {
            try {
                String languageName = t.nextToken();
                Configurations c = conf.getConfigurations(languageName);
                XSPLogicsheet logicsheet = new XSPLogicsheet(this.transformer, this.parser, null);
                String processorName = (String)c.get("processor");
                XSPLanguageProcessor languageProcessor = (XSPLanguageProcessor)this.factory.create(processorName);
                this.languages.put(languageName, languageProcessor);
                String logicsheetName = (String)c.get("logicsheet");
                InputStream logicsheetInputStream = this.getClass().getResourceAsStream(logicsheetName);
                if (logicsheetInputStream == null) {
                    throw new Exception("Resource '" + logicsheetName + "' could not be found.");
                }
                logicsheet.setStylesheet(this.parser.parse(new InputSource(logicsheetInputStream)));
                String preprocessorName = (String)c.get("preprocessor");
                if (processorName != null) {
                    XSPPreprocessor domPreprocessor = (XSPPreprocessor)this.factory.create(preprocessorName);
                    logicsheet.setPreprocessor(domPreprocessor);
                }
                xspLogicsheets.put(languageName, logicsheet);
            }
            catch (SAXException e) {
                throw new RuntimeException(Utils.getStackTraceAsString(e.getException()));
            }
            catch (Exception e) {
                throw new RuntimeException("Error while initializing XSP engine: " + Utils.getStackTraceAsString(e));
            }
        }
        this.byNamespace.put("xsp", xspLogicsheets);
        String repositoryName = (String)conf.get("repository");
        this.repositoryFile = new File(repositoryName);
        if (!this.repositoryFile.exists() && !this.repositoryFile.mkdirs()) {
            throw new RuntimeException("Can't create store repository: " + this.repositoryFile + ". Make sure it's there or you have writing permissions.<br>" + "In case this path is relative we highly suggest you to" + "change this to an absolute path so you can control its location directly" + "and provide valid access rights.");
        }
        if (!this.repositoryFile.canRead() || !this.repositoryFile.canWrite()) {
            throw new RuntimeException("Can't access store repository: " + this.repositoryFile.getAbsolutePath() + ". Make sure you have writing permissions.");
        }
        Enumeration enumeration = this.languages.elements();
        while (enumeration.hasMoreElements()) {
            XSPLanguageProcessor languageProcessor = (XSPLanguageProcessor)enumeration.nextElement();
            try {
                languageProcessor.setEncoding(this.encoding);
                languageProcessor.setRepository(this.repositoryFile);
            }
            catch (Exception e) {
                throw new RuntimeException("Error setting repository for language processor: " + e.getMessage());
            }
        }
        Configurations lsConf = conf.getConfigurations("logicsheet");
        Enumeration e = lsConf.keys();
        while (e.hasMoreElements()) {
            String str = (String)e.nextElement();
            String namespace = str.substring(0, str.indexOf(46));
            String language = str.substring(str.indexOf(46) + 1);
            String location = (String)lsConf.get(str);
            if (this.languages.get(language) == null) {
                throw new RuntimeException("Unsupported language '" + language + "' " + "in logicsheet '" + namespace + "'");
            }
            Hashtable<String, Object> byLanguage = (Hashtable<String, Object>)this.byNamespace.get(namespace);
            if (byLanguage == null) {
                byLanguage = new Hashtable<String, Object>(1);
            }
            try {
                Object resource = Utils.getLocationResource(location);
                if (resource == null) {
                    throw new Exception("Resource not found or retrieving error.");
                }
                XSPPreprocessor preprocessor = null;
                String preprocessorName = (String)lsConf.get(String.valueOf(namespace) + "." + language + ".preprocessor");
                if (preprocessorName != null) {
                    preprocessor = (XSPPreprocessor)this.factory.create(preprocessorName);
                }
                this.refreshLogicsheet(resource, preprocessor);
                byLanguage.put(language, this.store.get(resource.toString()));
            }
            catch (Exception ex) {
                this.logger.log(this, "Logicsheet for namespace '" + namespace + "' not found at '" + location + "' due to " + ex, 3);
            }
            this.byNamespace.put(namespace, byLanguage);
        }
    }

    public void init(Director director) {
        super.init(director);
        this.factory = (Factory)director.getActor("factory");
        this.store = (Store)director.getActor("store");
        this.monitor = new Monitor(8);
        this.parser = (Parser)director.getActor("parser");
        this.servletContext = (ServletContext)director.getActor("context");
        this.transformer = (Transformer)director.getActor("transformer");
        this.logger = (Logger)director.getActor("logger");
        this.byNamespace = new Hashtable(5);
        this.languages = new Hashtable(1);
    }

    protected XSPPage loadPage(XSPLanguageProcessor languageProcessor, PageEntry pageEntry, String filename) throws Exception {
        Hashtable<String, Object> pageParameters = new Hashtable<String, Object>();
        pageParameters.put("director", this.director);
        pageParameters.put("global", this.global);
        XSPPage page = languageProcessor.load(filename);
        page.init(pageParameters);
        pageEntry.setPage(page);
        return page;
    }

    public Document process(Document document, Dictionary parameters) throws Exception {
        XSPLanguageProcessor languageProcessor;
        Element root = document.getDocumentElement();
        String languageName = root.getAttribute("language");
        if (languageName.length() == 0) {
            languageName = DEFAULT_LANGUAGE;
        }
        if ((languageProcessor = (XSPLanguageProcessor)this.languages.get(languageName)) == null) {
            throw new Exception("Unsupported language: " + languageName);
        }
        HttpServletRequest request = (HttpServletRequest)parameters.get("request");
        HttpServletResponse response = (HttpServletResponse)parameters.get("response");
        String filename = Utils.getBasename(request, this.servletContext);
        File sourceFile = new File(filename);
        try {
            filename = sourceFile.getCanonicalPath();
        }
        catch (IOException iOException) {
            filename = sourceFile.getAbsolutePath();
        }
        PageEntry pageEntry = (PageEntry)this.store.get(filename);
        if (pageEntry == null) {
            String targetFilename = XSPUtil.normalizedBaseName(filename);
            String objectExtension = languageProcessor.getObjectExtension();
            if (objectExtension != null) {
                targetFilename = String.valueOf(targetFilename) + "." + objectExtension;
            }
            File targetFile = new File(String.valueOf(this.repositoryFile.getCanonicalPath()) + File.separator + targetFilename);
            pageEntry = new PageEntry(sourceFile, targetFile);
            pageEntry.setLogicsheets(this.getLogicsheets(document, request));
            if (targetFile.exists() && !pageEntry.hasChanged()) {
                this.loadPage(languageProcessor, pageEntry, targetFilename);
            }
            this.store.hold(filename, pageEntry);
        }
        PageEntry pageEntry2 = pageEntry = (PageEntry)this.store.get(filename);
        synchronized (pageEntry2) {
            if (pageEntry.hasChanged()) {
                String sourceFilename;
                String subdirName;
                File subdirFile;
                pageEntry.setLogicsheets(this.getLogicsheets(document, request));
                Hashtable<String, String> logicsheetParameters = new Hashtable<String, String>();
                logicsheetParameters.put("filename", filename);
                logicsheetParameters.put("language", languageName);
                Vector logicsheetList = pageEntry.getLogicsheets();
                int logicsheetCount = logicsheetList.size();
                int i = 0;
                while (i < logicsheetCount) {
                    Object resource = logicsheetList.elementAt(i);
                    XSPLogicsheet logicsheet = (XSPLogicsheet)this.store.get(resource.toString());
                    document = logicsheet.apply(document, logicsheetParameters);
                    ++i;
                }
                NamedNodeMap attributes = root.getAttributes();
                int attrCount = attributes.getLength();
                int i2 = 0;
                while (i2 < attrCount) {
                    Hashtable byLanguage;
                    String namespace;
                    Attr attr = (Attr)attributes.item(i2);
                    String attrName = attr.getName();
                    if (attrName.length() >= 6 && attrName.substring(0, 6).equals("xmlns:") && !(namespace = attrName.substring(6)).equals("xsp") && (byLanguage = (Hashtable)this.byNamespace.get(namespace)) != null) {
                        document = ((XSPLogicsheet)byLanguage.get(languageName)).apply(document, logicsheetParameters);
                    }
                    ++i2;
                }
                document = ((XSPLogicsheet)((Hashtable)this.byNamespace.get("xsp")).get(languageName)).apply(document, logicsheetParameters);
                Element sourceElement = document.getDocumentElement();
                StringBuffer buffer = new StringBuffer();
                Node node = sourceElement.getFirstChild();
                while (node != null) {
                    switch (node.getNodeType()) {
                        case 3: 
                        case 4: {
                            buffer.append(((Text)node).getData());
                            break;
                        }
                    }
                    node = node.getNextSibling();
                }
                String sourceCode = languageProcessor.formatCode(buffer.toString());
                sourceCode = languageProcessor.formatCode(sourceCode);
                String baseName = XSPUtil.normalizedBaseName(filename);
                String sourceExtension = languageProcessor.getSourceExtension();
                if (sourceExtension != null) {
                    baseName = String.valueOf(baseName) + "." + sourceExtension;
                }
                if (!(subdirFile = new File(subdirName = XSPUtil.pathComponent(sourceFilename = String.valueOf(this.repositoryFile.getCanonicalPath()) + File.separator + baseName))).exists() && !subdirFile.mkdirs()) {
                    throw new Exception("Can't create subdirectory: " + subdirName);
                }
                byte[] bytes = null;
                bytes = this.encoding == null ? sourceCode.getBytes() : sourceCode.getBytes(this.encoding);
                FileOutputStream fileWriter = new FileOutputStream(sourceFilename);
                fileWriter.write(bytes);
                fileWriter.flush();
                fileWriter.close();
                XSPPage page = pageEntry.getPage();
                if (page != null) {
                    languageProcessor.unload(page);
                }
                languageProcessor.compile(baseName);
                this.loadPage(languageProcessor, pageEntry, baseName);
            }
        }
        return pageEntry.getPage().getDocument(request, response);
    }

    private void refreshLogicsheet(Object resource) throws Exception {
        this.refreshLogicsheet(resource, null);
    }

    private void refreshLogicsheet(Object resource, XSPPreprocessor preprocessor) throws Exception {
        String name = resource.toString();
        XSPLogicsheet logicsheet = (XSPLogicsheet)this.store.get(name);
        if (logicsheet == null) {
            logicsheet = new XSPLogicsheet(this.transformer, this.parser, name);
        }
        logicsheet.setStylesheet(this.getDocument(resource));
        logicsheet.setPreprocessor(preprocessor);
        this.store.hold(name, logicsheet);
        this.monitor.invalidate(name);
        this.monitor.watch(name, resource);
    }

    public class PageEntry {
        protected File source;
        protected File target;
        protected XSPPage page;
        protected Vector logicsheets;

        public PageEntry(File source, File target) {
            this.source = source;
            this.target = target;
        }

        public Vector getLogicsheets() {
            return this.logicsheets;
        }

        public XSPPage getPage() {
            return this.page;
        }

        public boolean hasChanged() throws Exception {
            if (!this.target.exists() || this.target.lastModified() < this.source.lastModified()) {
                return true;
            }
            if (this.logicsheets != null) {
                int changeCount = 0;
                int logicsheetCount = this.logicsheets.size();
                int i = 0;
                while (i < logicsheetCount) {
                    Object resource = this.logicsheets.elementAt(i);
                    if (XSPProcessor.this.monitor.hasChanged(resource.toString()) || this.target.lastModified() < Monitor.timestamp(resource)) {
                        ++changeCount;
                        XSPProcessor.this.refreshLogicsheet(resource);
                    }
                    ++i;
                }
                return changeCount > 0;
            }
            return false;
        }

        public void setLogicsheets(Vector logicsheets) throws Exception {
            this.logicsheets = logicsheets;
            int logicsheetCount = this.logicsheets.size();
            int i = 0;
            while (i < logicsheetCount) {
                Object resource = this.logicsheets.elementAt(i);
                Object object = XSPProcessor.this.store.get(resource.toString());
                if (object == null) {
                    XSPProcessor.this.refreshLogicsheet(resource);
                }
                ++i;
            }
        }

        public void setPage(XSPPage page) {
            this.page = page;
        }
    }
}

