/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.xsp;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.cocoon.Tokenizer;
import org.apache.cocoon.Utils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class XSPUtil {
    private static int count = 0;

    public static String baseName(String filename) {
        return XSPUtil.baseName(filename, ".");
    }

    public static String baseName(String filename, String suffix) {
        int lastDot = filename.lastIndexOf(suffix);
        if (lastDot >= 0) {
            filename = filename.substring(0, lastDot);
        }
        return filename;
    }

    public static Node cloneNode(Node node, Document factory) {
        switch (node.getNodeType()) {
            case 4: {
                return factory.createCDATASection(node.getNodeValue());
            }
            case 8: {
                return factory.createComment(node.getNodeValue());
            }
            case 5: {
                return factory.createEntityReference(node.getNodeValue());
            }
            case 1: {
                Element input = (Element)node;
                Element output = factory.createElement(input.getTagName());
                NamedNodeMap attributes = input.getAttributes();
                int attrCount = attributes.getLength();
                int i = 0;
                while (i < attrCount) {
                    Attr attr = (Attr)attributes.item(i);
                    output.setAttribute(attr.getName(), attr.getValue());
                    ++i;
                }
                NodeList nodeList = input.getChildNodes();
                int childCount = nodeList.getLength();
                int i2 = 0;
                while (i2 < childCount) {
                    Node child = XSPUtil.cloneNode(nodeList.item(i2), factory);
                    if (child != null) {
                        output.appendChild(child);
                    }
                    ++i2;
                }
                return output;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)node;
                return factory.createProcessingInstruction(pi.getTarget(), pi.getData());
            }
            case 3: {
                return factory.createTextNode(node.getNodeValue());
            }
        }
        return null;
    }

    protected static void doMarkup(Node node, StringBuffer buffer) {
        switch (node.getNodeType()) {
            case 4: {
                buffer.append("<![CDATA[\n");
                buffer.append(node.getNodeValue());
                buffer.append("]]>\n");
                break;
            }
            case 9: 
            case 11: {
                NodeList nodeList = node.getChildNodes();
                int childCount = nodeList.getLength();
                int i = 0;
                while (i < childCount) {
                    XSPUtil.doMarkup(nodeList.item(i), buffer);
                    ++i;
                }
                break;
            }
            case 1: {
                Element element = (Element)node;
                buffer.append("<" + element.getTagName());
                NamedNodeMap attributes = element.getAttributes();
                int attributeCount = attributes.getLength();
                int i = 0;
                while (i < attributeCount) {
                    Attr attribute = (Attr)attributes.item(i);
                    buffer.append(" ");
                    buffer.append(attribute.getName());
                    buffer.append("=\"");
                    buffer.append(attribute.getValue());
                    buffer.append("\"");
                    ++i;
                }
                NodeList nodeList = element.getChildNodes();
                int childCount = nodeList.getLength();
                if (childCount == 0) {
                    buffer.append("/>\n");
                    break;
                }
                buffer.append(">");
                int i2 = 0;
                while (i2 < childCount) {
                    XSPUtil.doMarkup(nodeList.item(i2), buffer);
                    ++i2;
                }
                buffer.append("</");
                buffer.append(element.getTagName());
                buffer.append(">");
                break;
            }
            case 8: {
                buffer.append("<!-- ");
                buffer.append(node.getNodeValue());
                buffer.append(" -->\n");
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)node;
                buffer.append("<?");
                buffer.append(pi.getTarget());
                buffer.append(" ");
                buffer.append(pi.getData());
                buffer.append("?>\n");
                break;
            }
            case 3: {
                buffer.append(XSPUtil.encodeMarkup(node.getNodeValue()));
                break;
            }
        }
    }

    public static String encodeMarkup(String string) {
        char[] array = string.toCharArray();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            switch (array[i]) {
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                default: {
                    buffer.append(array[i]);
                    break;
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String fileComponent(String filename) {
        int i = filename.lastIndexOf(File.separator);
        return i >= 0 ? filename.substring(i + 1) : filename;
    }

    public static String formDecode(String s) throws Exception {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    break;
                }
                case '%': {
                    try {
                        sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                    i += 2;
                    break;
                }
                default: {
                    sb.append(c);
                    break;
                }
            }
            ++i;
        }
        String result = sb.toString();
        byte[] inputBytes = result.getBytes("8859_1");
        return new String(inputBytes);
    }

    public static String formEncode(String text) throws Exception {
        char[] c = text.toCharArray();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < c.length) {
            if (XSPUtil.isAlphaNumeric(c[i])) {
                buffer.append(c[i]);
            } else if (c[i] == ' ') {
                buffer.append('+');
            } else {
                buffer.append('%');
                String hex = Integer.toHexString((byte)c[i]).toUpperCase();
                if (hex.length() < 2) {
                    buffer.append('0');
                }
                buffer.append(hex);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String formatDate(Date date, String pattern) {
        if (pattern == null || pattern.length() == 0) {
            pattern = "yyyy/MM/dd hh:mm:ss aa";
        }
        try {
            return new SimpleDateFormat(pattern).format(date);
        }
        catch (Exception exception) {
            return date.toString();
        }
    }

    public static String getContents(InputStream in) throws IOException {
        return XSPUtil.getContents(new InputStreamReader(in));
    }

    public static String getContents(Reader reader) throws IOException {
        int len;
        char[] chr = new char[4096];
        StringBuffer buffer = new StringBuffer();
        while ((len = reader.read(chr)) > 0) {
            buffer.append(chr, 0, len);
        }
        return buffer.toString();
    }

    public static synchronized int getCount() {
        return ++count;
    }

    public static String getFileContents(String filename) throws IOException {
        return XSPUtil.getContents(new FileReader(filename));
    }

    public static synchronized int getSessionCount(HttpSession session) {
        Integer integer = (Integer)session.getValue("util.counter");
        if (integer == null) {
            integer = new Integer(0);
        }
        int cnt = integer + 1;
        session.putValue("util.counter", (Object)new Integer(cnt));
        return cnt;
    }

    public static String getURLContents(String url) throws IOException {
        return XSPUtil.getContents(new URL(url).openStream());
    }

    public static boolean isAlphaNumeric(char c) {
        return c == '_' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9';
    }

    public static String normalizedBaseName(String filename) {
        filename = XSPUtil.baseName(filename);
        return XSPUtil.normalizedName(filename);
    }

    public static String normalizedName(String filename) {
        String[] path = XSPUtil.split(filename, File.separator);
        int start = path[0].length() == 0 ? 1 : 0;
        StringBuffer buffer = new StringBuffer();
        int i = start;
        while (i < path.length) {
            if (i > start) {
                buffer.append(File.separator);
            }
            buffer.append('_');
            char[] chars = path[i].toCharArray();
            int j = 0;
            while (j < chars.length) {
                if (XSPUtil.isAlphaNumeric(chars[j])) {
                    buffer.append(chars[j]);
                } else {
                    buffer.append('_');
                }
                ++j;
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String pathComponent(String filename) {
        int i = filename.lastIndexOf(File.separator);
        return i >= 0 ? filename.substring(0, i) : filename;
    }

    public static String relativeFilename(String filename, HttpServletRequest request) throws IOException {
        return XSPUtil.relativeFilename(filename, request, null);
    }

    public static String relativeFilename(String filename, HttpServletRequest request, ServletContext context) throws IOException {
        File file = new File(filename);
        if (file.isAbsolute()) {
            return filename;
        }
        return new File(new File(Utils.getBasename(request, context)).getParent(), filename).getCanonicalPath();
    }

    public static String[] split(String line) {
        return XSPUtil.split(line, " \t\r\f\n");
    }

    public static String[] split(String line, String delimiter) {
        Tokenizer tokenizer = new Tokenizer(line, delimiter);
        int tokenCount = tokenizer.countTokens();
        String[] result = new String[tokenCount];
        int i = 0;
        while (i < tokenCount) {
            result[i] = tokenizer.nextToken();
            ++i;
        }
        return result;
    }

    public static String toMarkup(Node node) {
        StringBuffer buffer = new StringBuffer();
        XSPUtil.doMarkup(node, buffer);
        return buffer.toString();
    }
}

