/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.xsp.library.sql;

import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.Format;
import java.util.Hashtable;
import org.apache.cocoon.processor.xsp.library.sql.Column;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSPSQLLibrary {
    public static Element createElement(Document document, String namespace, String name) {
        if (namespace == null || namespace.equals("")) {
            return document.createElement(name);
        }
        return document.createElement(String.valueOf(namespace) + ':' + name);
    }

    protected static Column[] getColumns(ResultSetMetaData md, String tag_case) throws SQLException {
        Column[] columns;
        block4: {
            block5: {
                block3: {
                    columns = new Column[md.getColumnCount()];
                    if (!tag_case.equals("preserve")) break block3;
                    int i = 0;
                    while (i < columns.length) {
                        columns[i] = new Column(md.getColumnName(i + 1), md.getColumnType(i + 1), md.getColumnTypeName(i + 1));
                        ++i;
                    }
                    break block4;
                }
                if (!tag_case.equals("lower")) break block5;
                int i = 0;
                while (i < columns.length) {
                    columns[i] = new Column(md.getColumnName(i + 1).toLowerCase(), md.getColumnType(i + 1), md.getColumnTypeName(i + 1));
                    ++i;
                }
                break block4;
            }
            if (!tag_case.equals("upper")) break block4;
            int i = 0;
            while (i < columns.length) {
                columns[i] = new Column(md.getColumnName(i + 1).toUpperCase(), md.getColumnType(i + 1), md.getColumnTypeName(i + 1));
                ++i;
            }
        }
        return columns;
    }

    public static String getCountQuery(String query) {
        String lowercase_query = query.toLowerCase();
        int from_index = lowercase_query.indexOf(" from ");
        return "SELECT count(*) FROM " + query.substring(from_index + 6);
    }

    public static Element[] processQuery(Document document, String driver, String dburl, String username, String password, String doc_element_name, String row_element_name, String tag_case, String null_indicator, String id_attribute, String id_attribute_column, Integer max_rows, Integer skip_rows, String count_attribute, String query_attribute, String skip_rows_attribute, String max_rows_attribute, String update_rows_attribute, String namespace, String query, Hashtable column_formats) throws Exception {
        ResultSet rs;
        String count_query;
        Node results_node;
        Class.forName(driver).newInstance();
        Connection conn = username == null ? DriverManager.getConnection(dburl) : DriverManager.getConnection(dburl, username, password);
        boolean create_row_elements = true;
        if (row_element_name.equals("")) {
            create_row_elements = false;
        }
        boolean create_id_attribute = true;
        if (id_attribute.equals("")) {
            create_id_attribute = false;
        }
        boolean indicate_nulls = false;
        if (null_indicator.equals("y")) {
            indicate_nulls = true;
        } else if (null_indicator.equals("yes")) {
            indicate_nulls = true;
        }
        Statement st = conn.createStatement();
        Element results_element = null;
        if (doc_element_name.equals("")) {
            results_node = document.createDocumentFragment();
        } else {
            results_element = XSPSQLLibrary.createElement(document, namespace, doc_element_name);
            results_node = results_element;
        }
        if (results_element != null && !count_attribute.equals("") && (count_query = XSPSQLLibrary.getCountQuery(query)) != null) {
            rs = st.executeQuery(count_query);
            if (rs.next()) {
                results_element.setAttribute(count_attribute, rs.getString(1));
            }
            rs.close();
        }
        if (results_element != null && !query_attribute.equals("")) {
            results_element.setAttribute(query_attribute, URLEncoder.encode(query));
        }
        if (results_element != null && !skip_rows_attribute.equals("")) {
            results_element.setAttribute(skip_rows_attribute, String.valueOf(String.valueOf(skip_rows)));
        }
        if (results_element != null && !max_rows_attribute.equals("")) {
            results_element.setAttribute(max_rows_attribute, String.valueOf(String.valueOf(max_rows)));
        }
        if (!st.execute(query)) {
            int update_rows = st.getUpdateCount();
            if (results_element != null) {
                results_element.setAttribute(update_rows_attribute, String.valueOf(update_rows));
            }
        } else {
            rs = st.getResultSet();
            ResultSetMetaData md = rs.getMetaData();
            if (tag_case.equals("")) {
                tag_case = "preserve";
            }
            Column[] columns = XSPSQLLibrary.getColumns(md, tag_case);
            int id_attribute_column_index = -1;
            if (create_id_attribute) {
                int i = 0;
                while (i < columns.length) {
                    if (columns[i].name.equals(id_attribute_column)) {
                        id_attribute_column_index = i;
                    }
                    ++i;
                }
            }
            Node row_node = results_node;
            Element row_element = null;
            int count = 0;
            if (skip_rows > 0) {
                while (rs.next()) {
                    if (++count == skip_rows) break;
                }
            }
            while (rs.next()) {
                if (create_row_elements) {
                    row_element = XSPSQLLibrary.createElement(document, namespace, row_element_name);
                    row_node = row_element;
                    if (create_id_attribute && id_attribute_column_index == -1) {
                        row_element.setAttribute(id_attribute, String.valueOf(count));
                    }
                }
                int i = 0;
                while (i < columns.length) {
                    Object value = rs.getObject(i + 1);
                    Format format = (Format)column_formats.get(columns[i].name);
                    String formatted_value = value == null ? "" : (format == null ? (value instanceof byte[] ? new String((byte[])value) : (value instanceof char[] ? new String((char[])value) : value.toString())) : format.format(value));
                    if (create_row_elements && create_id_attribute && id_attribute_column_index == i) {
                        row_element.setAttribute(id_attribute, formatted_value);
                    } else if (value != null || indicate_nulls) {
                        Element column_element = XSPSQLLibrary.createElement(document, namespace, columns[i].name);
                        if (value == null && indicate_nulls) {
                            column_element.setAttribute("NULL", "YES");
                            column_element.appendChild(document.createTextNode(""));
                        } else {
                            column_element.appendChild(document.createTextNode(formatted_value));
                        }
                        row_node.appendChild(column_element);
                    }
                    ++i;
                }
                if (create_row_elements) {
                    results_node.appendChild(row_node);
                }
                if (max_rows != -1 && count - skip_rows == max_rows - 1) break;
                ++count;
            }
            rs.close();
        }
        st.close();
        conn.close();
        if (results_element != null) {
            Element[] ary = new Element[]{results_element};
            return ary;
        }
        NodeList nodes = results_node.getChildNodes();
        int length = nodes.getLength();
        Element[] ary = new Element[length];
        int i = 0;
        while (i < length) {
            ary[i] = (Element)nodes.item(i);
            ++i;
        }
        return ary;
    }
}

