/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class Target {
    private String name;
    private String condition = "";
    private Vector dependencies = new Vector(2);
    private Vector tasks = new Vector(5);
    private Project project;

    public void addDependency(String dependency) {
        this.dependencies.addElement(dependency);
    }

    public void addTask(Task task) {
        this.tasks.addElement(task);
    }

    public void execute() throws BuildException {
        if ("".equals(this.condition) || this.project.getProperty(this.condition) != null) {
            Enumeration enumeration = this.tasks.elements();
            while (enumeration.hasMoreElements()) {
                Task task = (Task)enumeration.nextElement();
                task.execute();
            }
        } else {
            this.project.log("Skipped because property '" + this.condition + "' not set.", this.name, 3);
        }
    }

    public Enumeration getDependencies() {
        return this.dependencies.elements();
    }

    public String getName() {
        return this.name;
    }

    public Project getProject() {
        return this.project;
    }

    public void setCondition(String property) {
        this.condition = property == null ? "" : property;
    }

    public void setDepends(String depS) {
        if (depS.length() > 0) {
            StringTokenizer tok = new StringTokenizer(depS, ",", false);
            while (tok.hasMoreTokens()) {
                this.addDependency(tok.nextToken().trim());
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProject(Project project) {
        this.project = project;
    }
}

