/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class Exec
extends Task {
    private String os;
    private String out;
    private String dir = ".";
    private String command;
    private static final int BUFFER_SIZE = 512;

    public void execute() throws BuildException {
        this.run(this.command);
    }

    protected int run(String command) throws BuildException {
        int err = -1;
        String myos = System.getProperty("os.name");
        this.project.log("Myos = " + myos, 3);
        if (this.os != null && this.os.indexOf(myos) < 0) {
            this.project.log("Not found in " + this.os, 3);
            return 0;
        }
        if (myos.toLowerCase().indexOf("windows") >= 0) {
            if (!this.dir.equals(".")) {
                command = "cmd /c cd " + this.project.resolveFile(this.dir) + " && " + command;
            }
        } else {
            String ant = this.project.getProperty("ant.home");
            if (ant == null) {
                throw new BuildException("Property 'ant.home' not found");
            }
            String antRun = this.project.resolveFile(String.valueOf(ant) + "/bin/antRun").toString();
            command = String.valueOf(antRun) + " " + this.project.resolveFile(this.dir) + " " + command;
        }
        try {
            this.project.log(command, "exec", 3);
            Process proc = Runtime.getRuntime().exec(command);
            PrintWriter fos = null;
            if (this.out != null) {
                fos = new PrintWriter(new FileWriter(this.out));
                this.project.log("Output redirected to " + this.out, 3);
            }
            StreamPumper inputPumper = new StreamPumper(proc.getInputStream(), "exec", this.project, fos);
            StreamPumper errorPumper = new StreamPumper(proc.getErrorStream(), "error", this.project, fos);
            inputPumper.start();
            errorPumper.start();
            proc.waitFor();
            inputPumper.join();
            errorPumper.join();
            proc.destroy();
            if (fos != null) {
                fos.close();
            }
            if ((err = proc.exitValue()) != 0) {
                this.project.log("Result: " + err, "exec", 0);
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Error exec: " + command);
        }
        catch (InterruptedException interruptedException) {}
        return err;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setDir(String d) {
        this.dir = d;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public void setOutput(String out) {
        this.out = out;
    }

    class StreamPumper
    extends Thread {
        private BufferedReader din;
        private String name;
        private boolean endOfStream = false;
        private int SLEEP_TIME = 5;
        private Project project;
        private PrintWriter fos;

        public StreamPumper(InputStream is, String name, Project project, PrintWriter fos) {
            this.din = new BufferedReader(new InputStreamReader(is));
            this.name = name;
            this.project = project;
            this.fos = fos;
        }

        public void pumpStream() throws IOException {
            byte[] buf = new byte[512];
            if (!this.endOfStream) {
                String line = this.din.readLine();
                if (line != null) {
                    if (this.fos == null) {
                        this.project.log(line, this.name, 2);
                    } else {
                        this.fos.println(line);
                    }
                } else {
                    this.endOfStream = true;
                }
            }
        }

        public void run() {
            try {
                try {
                    while (!this.endOfStream) {
                        this.pumpStream();
                        Thread.sleep(this.SLEEP_TIME);
                    }
                }
                catch (InterruptedException interruptedException) {}
                this.din.close();
            }
            catch (IOException iOException) {}
        }
    }
}

