/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Exec;

public class Java
extends Exec {
    private String classname = null;
    private String args = null;
    private String jvmargs = null;
    private String classpath = null;
    private boolean fork = false;

    protected String[] array(Vector v) {
        String[] s = new String[v.size()];
        Enumeration e = v.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            s[i] = (String)e.nextElement();
            ++i;
        }
        return s;
    }

    public void execute() throws BuildException {
        this.project.log("Calling " + this.classname, "java", 3);
        if (this.classname == null) {
            throw new BuildException("Class name must not be null.");
        }
        if (this.fork) {
            StringBuffer b = new StringBuffer();
            b.append("java ");
            if (this.classpath != null) {
                b.append("-classpath ");
                b.append(this.classpath);
                b.append(" ");
            }
            if (this.jvmargs != null) {
                b.append(this.jvmargs);
                b.append(" ");
            }
            b.append(this.classname);
            if (this.args != null) {
                b.append(" ");
                b.append(this.args);
            }
            this.run(b.toString());
        } else {
            Vector argList = this.tokenize(this.args);
            if (this.jvmargs != null) {
                this.project.log("JVM args and classpath ignored when same JVM is used.", "java", 3);
            }
            this.project.log("Java args: " + argList.toString(), "java", 3);
            this.run(this.classname, argList);
        }
    }

    protected void run(String classname, Vector args) throws BuildException {
        try {
            Class[] param = new Class[]{Class.forName("[Ljava.lang.String;")};
            Class<?> c = Class.forName(classname);
            Method main = c.getMethod("main", param);
            Object[] a = new Object[]{this.array(args)};
            main.invoke(null, a);
        }
        catch (NullPointerException nullPointerException) {
            throw new BuildException("Could not find main() method in " + classname);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BuildException("Could not find " + classname + ". Make sure you have it in your classpath");
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (!(t instanceof SecurityException)) {
                throw new BuildException(t.toString());
            }
        }
        catch (Exception e) {
            throw new BuildException(e.toString());
        }
    }

    public void setArgs(String s) {
        this.args = s;
    }

    public void setClass(String s) {
        this.project.log("The class attribute is deprecated. Please use the classname attribute.", 1);
        this.classname = s;
    }

    public void setClassname(String s) {
        this.classname = s;
    }

    public void setClasspath(String s) {
        this.classpath = this.project.translatePath(s);
    }

    public void setFork(String s) {
        this.fork = Project.toBoolean(s);
    }

    public void setJvmargs(String s) {
        this.jvmargs = s;
    }

    protected Vector tokenize(String args) {
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(args, " ");
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        return v;
    }
}

