/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.Version;
import org.apache.fop.render.awt.AWTRenderer;
import org.apache.fop.viewer.Command;
import org.apache.fop.viewer.PreviewDialog;
import org.apache.fop.viewer.SecureResourceBundle;
import org.apache.fop.viewer.Translator;
import org.apache.fop.viewer.UserMessage;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;

public class AWTCommandLine {
    public static String DEFAULT_TRANSLATION_PATH = "../viewer/resources/resources." + System.getProperty("user.language");
    private Translator resource;

    public AWTCommandLine(String string, String string2) {
        this.resource = this.getResourceBundle(string2);
        String string3 = new File(string2).getAbsoluteFile().getParent();
        if (!string3.endsWith(System.getProperty("file.separator"))) {
            string3 = string3 + System.getProperty("file.separator");
        }
        string3 = string3 + "messages." + System.getProperty("user.language");
        System.out.println("Set messages resource: " + string3);
        UserMessage.setTranslator(this.getResourceBundle(string3));
        this.resource.setMissingEmphasized(false);
        if (!this.resource.isSourceFound()) {
            UserMessage.show("TRANSLATION_SOURCE_NOT_FOUND", new File(string2).getAbsolutePath());
        }
        AWTRenderer aWTRenderer = new AWTRenderer(this.resource);
        PreviewDialog previewDialog = this.createPreviewDialog(aWTRenderer, this.resource);
        aWTRenderer.setProgressListener(previewDialog);
        previewDialog.progress(this.resource.getString("Init parser") + " ...");
        Parser parser = AWTCommandLine.createParser();
        if (parser == null) {
            System.err.println("ERROR: Unable to create SAX parser");
            System.exit(1);
        }
        try {
            Driver driver = new Driver();
            driver.setRenderer(aWTRenderer);
            previewDialog.progress(this.resource.getString("Init mappings") + " ...");
            driver.addElementMapping("org.apache.fop.fo.StandardElementMapping");
            driver.addElementMapping("org.apache.fop.svg.SVGElementMapping");
            previewDialog.progress(this.resource.getString("Build FO tree") + " ...");
            driver.buildFOTree(parser, AWTCommandLine.fileInputSource(string));
            previewDialog.progress(this.resource.getString("Layout FO tree") + " ...");
            driver.format();
            previewDialog.progress(this.resource.getString("Render") + " ...");
            driver.render();
            previewDialog.progress(this.resource.getString("Show"));
        }
        catch (Exception exception) {
            System.err.println("FATAL ERROR: " + exception.getMessage());
            exception.printStackTrace();
            System.exit(1);
        }
    }

    static Parser createParser() {
        String string = System.getProperty("org.xml.sax.parser");
        if (string == null) {
            string = "com.jclark.xml.sax.Driver";
        }
        System.err.println("using SAX parser " + string);
        try {
            return (Parser)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Could not find " + string);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Could not instantiate " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Could not access " + string);
        }
        catch (ClassCastException classCastException) {
            System.err.println(string + " is not a SAX driver");
        }
        return null;
    }

    protected PreviewDialog createPreviewDialog(AWTRenderer aWTRenderer, Translator translator) {
        PreviewDialog previewDialog = new PreviewDialog(aWTRenderer, translator);
        previewDialog.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = previewDialog.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        ((Component)previewDialog).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        ((Component)previewDialog).setVisible(true);
        return previewDialog;
    }

    protected static InputSource fileInputSource(String string) {
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        String string3 = System.getProperty("file.separator");
        if (string3 != null && string3.length() == 1) {
            string2 = string2.replace(string3.charAt(0), '/');
        }
        if (string2.length() > 0 && string2.charAt(0) != '/') {
            string2 = '/' + string2;
        }
        try {
            return new InputSource(new URL("file", null, string2).toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error("unexpected MalformedURLException");
        }
    }

    private SecureResourceBundle getResourceBundle(String string) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (Exception exception) {
            System.out.println("Abgefangene Exception: " + exception.getMessage());
        }
        return new SecureResourceBundle(fileInputStream);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(new MetalLookAndFeel());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        System.err.println(Version.getVersion());
        if (stringArray.length < 1 || stringArray.length > 3) {
            System.err.println("usage: java AWTCommandLine formatting-object-file [translation-file] [image-dir]");
            System.exit(1);
        }
        string = stringArray[0];
        if (stringArray.length > 1) {
            string2 = stringArray[1];
        }
        if (stringArray.length > 2) {
            string3 = stringArray[2];
            if (!string3.endsWith(System.getProperty("file.separator"))) {
                string3 = string3 + System.getProperty("file.separator");
            }
            Command.IMAGE_DIR = string3;
        }
        if (string2 == null) {
            string2 = DEFAULT_TRANSLATION_PATH;
        }
        new AWTCommandLine(string, string2);
    }
}

