/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.ListItemBody;
import org.apache.fop.fo.flow.ListItemLabel;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.FontState;

public class ListItem
extends FObj {
    FontState fs;
    int align;
    int alignLast;
    int breakBefore;
    int breakAfter;
    int lineHeight;
    int startIndent;
    int endIndent;
    int spaceBefore;
    int spaceAfter;

    public static FObj.Maker maker() {
        return new Maker();
    }

    public ListItem(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:list-item";
    }

    public Status layout(Area area) throws FOPException {
        Status status;
        Object object;
        Object object2;
        if (this.marker == -1000) {
            object2 = this.properties.get("font-family").getString();
            String string = this.properties.get("font-style").getString();
            object = this.properties.get("font-weight").getString();
            int n = this.properties.get("font-size").getLength().mvalue();
            this.fs = new FontState(area.getFontInfo(), (String)object2, string, (String)object, n);
            this.align = this.properties.get("text-align").getEnum();
            this.alignLast = this.properties.get("text-align-last").getEnum();
            this.lineHeight = this.properties.get("line-height").getLength().mvalue();
            this.startIndent = this.properties.get("start-indent").getLength().mvalue();
            this.endIndent = this.properties.get("end-indent").getLength().mvalue();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.marker = 0;
        }
        if (area instanceof BlockArea) {
            area.end();
        }
        if (this.spaceBefore != 0) {
            area.addDisplaySpace(this.spaceBefore);
        }
        this.startIndent += this.bodyIndent;
        object2 = new BlockArea(this.fs, area.getAllocationWidth(), area.spaceLeft(), this.startIndent, this.endIndent, 0, this.align, this.alignLast, this.lineHeight);
        ((Area)object2).setPage(area.getPage());
        ((BlockArea)object2).start();
        int n = this.children.size();
        if (n != 2) {
            throw new FOPException("list-item must have exactly two children");
        }
        object = (ListItemLabel)this.children.elementAt(0);
        ListItemBody listItemBody = (ListItemBody)this.children.elementAt(1);
        ((FONode)object).setDistanceBetweenStarts(this.distanceBetweenStarts);
        ((FONode)object).setLabelSeparation(this.labelSeparation);
        ((FONode)object).setBodyIndent(this.bodyIndent);
        listItemBody.setDistanceBetweenStarts(this.distanceBetweenStarts);
        listItemBody.setBodyIndent(this.bodyIndent);
        listItemBody.setLabelSeparation(this.labelSeparation);
        if (this.marker == 0 && (status = ((ListItemLabel)object).layout((Area)object2)).isIncomplete()) {
            return status;
        }
        status = listItemBody.layout((Area)object2);
        if (status.isIncomplete()) {
            ((BlockArea)object2).end();
            area.addChild((Box)object2);
            area.increaseHeight(((Area)object2).getHeight());
            this.marker = 1;
            return status;
        }
        ((BlockArea)object2).end();
        area.addChild((Box)object2);
        area.increaseHeight(((Area)object2).getHeight());
        if (this.spaceAfter != 0) {
            area.addDisplaySpace(this.spaceAfter);
        }
        if (area instanceof BlockArea) {
            area.start();
        }
        return new Status(1);
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new ListItem(fObj, propertyList);
        }
    }
}

