/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.FontState;

public class TableCell
extends FObj {
    FontState fs;
    int startIndent;
    int endIndent;
    int spaceBefore;
    int spaceAfter;
    ColorType backgroundColor;
    protected int startOffset;
    protected int width;
    protected int height = 0;
    BlockArea blockArea;

    public static FObj.Maker maker() {
        return new Maker();
    }

    public TableCell(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:table-cell";
    }

    public void setStartOffset(int n) {
        this.startOffset = n;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public Status layout(Area area) throws FOPException {
        Object object;
        if (this.marker == -1001) {
            return new Status(1);
        }
        if (this.marker == -1000) {
            String string = this.properties.get("font-family").getString();
            String string2 = this.properties.get("font-style").getString();
            object = this.properties.get("font-weight").getString();
            int n = this.properties.get("font-size").getLength().mvalue();
            this.fs = new FontState(area.getFontInfo(), string, string2, (String)object, n);
            this.startIndent = this.properties.get("start-indent").getLength().mvalue();
            this.endIndent = this.properties.get("end-indent").getLength().mvalue();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.backgroundColor = this.properties.get("background-color").getColorType();
            if (area instanceof BlockArea) {
                area.end();
            }
            this.marker = 0;
        }
        if (this.spaceBefore != 0 && this.marker == 0) {
            area.addDisplaySpace(this.spaceBefore);
        }
        this.blockArea = new BlockArea(this.fs, area.getAllocationWidth(), area.spaceLeft(), this.startIndent, this.endIndent, 0, 0, 0, 0);
        this.blockArea.setPage(area.getPage());
        this.blockArea.setBackgroundColor(this.backgroundColor);
        this.blockArea.start();
        this.height = 0;
        int n = this.children.size();
        int n2 = this.marker;
        while (n2 < n) {
            object = (FObj)this.children.elementAt(n2);
            ((FONode)object).setIsInTableCell();
            ((FONode)object).forceStartOffset(this.startOffset);
            ((FONode)object).forceWidth(this.width);
            Status status = ((FObj)object).layout(this.blockArea);
            if (status.isIncomplete()) {
                this.marker = n2;
                if (n2 == 0 && status.getCode() == 2) {
                    return new Status(2);
                }
                return new Status(3);
            }
            this.height = this.blockArea.getHeight();
            ++n2;
        }
        this.blockArea.end();
        area.addChild(this.blockArea);
        return new Status(1);
    }

    public int getHeight() {
        return this.height;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new TableCell(fObj, propertyList);
        }
    }
}

