/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.util.Vector;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.DisplaySpace;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.Page;

public abstract class Area
extends Box {
    protected FontState fontState;
    protected Vector children = new Vector();
    protected int maxHeight;
    protected int currentHeight = 0;
    protected int contentRectangleWidth;
    protected int allocationWidth;
    protected AreaContainer areaContainer;
    protected Page page;
    protected ColorType backgroundColor;
    protected int paddingTop;
    protected int paddingLeft;
    protected int paddingBottom;
    protected int paddingRight;

    public Area(FontState fontState) {
        this.fontState = fontState;
    }

    public Area(FontState fontState, int n, int n2) {
        this.fontState = fontState;
        this.allocationWidth = n;
        this.maxHeight = n2;
    }

    public void addChild(Box box) {
        this.children.addElement(box);
        box.parent = this;
    }

    public void addChildAtStart(Box box) {
        this.children.insertElementAt(box, 0);
        box.parent = this;
    }

    public void addDisplaySpace(int n) {
        this.addChild(new DisplaySpace(n));
        this.currentHeight += n;
    }

    public FontInfo getFontInfo() {
        return this.page.getFontInfo();
    }

    public void end() {
    }

    public int getAllocationWidth() {
        return this.allocationWidth;
    }

    public Vector getChildren() {
        return this.children;
    }

    public int getContentWidth() {
        return this.contentRectangleWidth;
    }

    public FontState getFontState() {
        return this.fontState;
    }

    public int getHeight() {
        return this.currentHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public Page getPage() {
        return this.page;
    }

    public ColorType getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getPaddingTop() {
        return this.paddingTop;
    }

    public int getPaddingLeft() {
        return this.paddingLeft;
    }

    public int getPaddingBottom() {
        return this.paddingBottom;
    }

    public int getPaddingRight() {
        return this.paddingRight;
    }

    public void increaseHeight(int n) {
        this.currentHeight += n;
    }

    protected void removeChild(Area area) {
        this.currentHeight -= area.getHeight();
        this.children.removeElement(area);
    }

    public void remove() {
        this.parent.removeChild(this);
    }

    public void setPage(Page page) {
        this.page = page;
    }

    public void setBackgroundColor(ColorType colorType) {
        this.backgroundColor = colorType;
    }

    public void setPadding(int n, int n2, int n3, int n4) {
        this.paddingTop = n;
        this.paddingLeft = n2;
        this.paddingBottom = n3;
        this.paddingRight = n4;
    }

    public int spaceLeft() {
        return this.maxHeight - this.currentHeight;
    }

    public void start() {
    }
}

