/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.util.Vector;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.AreaTree;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.LinkSet;
import org.apache.fop.render.Renderer;

public class Page {
    private int height;
    private int width;
    private AreaContainer body;
    private AreaContainer before;
    private AreaContainer after;
    private AreaContainer start;
    private AreaContainer end;
    private AreaTree areaTree;
    protected int pageNumber = 0;
    protected Vector linkSets = new Vector();

    Page(AreaTree areaTree, int n, int n2) {
        this.areaTree = areaTree;
        this.height = n;
        this.width = n2;
    }

    public void setNumber(int n) {
        this.pageNumber = n;
    }

    public int getNumber() {
        return this.pageNumber;
    }

    void addAfter(AreaContainer areaContainer) {
        this.after = areaContainer;
        areaContainer.setPage(this);
    }

    void addBefore(AreaContainer areaContainer) {
        this.before = areaContainer;
        areaContainer.setPage(this);
    }

    void addBody(AreaContainer areaContainer) {
        this.body = areaContainer;
        areaContainer.setPage(this);
    }

    void addEnd(AreaContainer areaContainer) {
        this.end = areaContainer;
        areaContainer.setPage(this);
    }

    void addStart(AreaContainer areaContainer) {
        this.start = areaContainer;
        areaContainer.setPage(this);
    }

    public void render(Renderer renderer) {
        renderer.renderPage(this);
    }

    public AreaContainer getAfter() {
        return this.after;
    }

    public AreaContainer getBefore() {
        return this.before;
    }

    public AreaContainer getBody() {
        return this.body;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public FontInfo getFontInfo() {
        return this.areaTree.getFontInfo();
    }

    public void addLinkSet(LinkSet linkSet) {
        this.linkSets.addElement(linkSet);
    }

    public Vector getLinkSets() {
        return this.linkSets;
    }

    public boolean hasLinks() {
        return !this.linkSets.isEmpty();
    }
}

