/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import org.apache.fop.image.FopImage;
import org.apache.fop.pdf.PDFAction;
import org.apache.fop.pdf.PDFFileSpec;
import org.apache.fop.pdf.PDFFont;
import org.apache.fop.pdf.PDFInfo;
import org.apache.fop.pdf.PDFLink;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFPages;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFRoot;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFXObject;

public class PDFDocument {
    protected static final String pdfVersion = "1.2";
    protected int position = 0;
    protected Vector location = new Vector();
    protected int objectcount = 0;
    protected Vector objects = new Vector();
    protected int xref;
    protected PDFRoot root;
    protected PDFInfo info;
    protected PDFResources resources;
    protected int xObjectCount = 0;
    protected Vector xObjects = new Vector();

    public PDFDocument() {
        this.root = this.makeRoot();
        this.info = this.makeInfo();
        this.resources = this.makeResources();
    }

    public void setProducer(String string) {
        this.info.setProducer(string);
    }

    protected PDFRoot makeRoot() {
        PDFRoot pDFRoot = new PDFRoot(++this.objectcount);
        this.objects.addElement(pDFRoot);
        PDFPages pDFPages = new PDFPages(++this.objectcount);
        this.objects.addElement(pDFPages);
        pDFRoot.setRootPages(pDFPages);
        return pDFRoot;
    }

    protected PDFInfo makeInfo() {
        PDFInfo pDFInfo = new PDFInfo(++this.objectcount);
        this.objects.addElement(pDFInfo);
        return pDFInfo;
    }

    private PDFResources makeResources() {
        PDFResources pDFResources = new PDFResources(++this.objectcount);
        this.objects.addElement(pDFResources);
        return pDFResources;
    }

    public PDFFont makeFont(String string, String string2, String string3) {
        PDFFont pDFFont = new PDFFont(++this.objectcount, string, string2, string3);
        this.objects.addElement(pDFFont);
        return pDFFont;
    }

    public int addImage(FopImage fopImage) {
        PDFXObject pDFXObject = new PDFXObject(++this.objectcount, ++this.xObjectCount, fopImage);
        this.objects.addElement(pDFXObject);
        this.xObjects.addElement(pDFXObject);
        return this.xObjectCount;
    }

    public PDFPage makePage(PDFResources pDFResources, PDFStream pDFStream, int n, int n2) {
        PDFPage pDFPage = new PDFPage(++this.objectcount, pDFResources, pDFStream, n, n2);
        this.objects.addElement(pDFPage);
        this.root.addPage(pDFPage);
        return pDFPage;
    }

    public PDFLink makeLink(Rectangle rectangle, String string) {
        PDFLink pDFLink = new PDFLink(++this.objectcount, string, rectangle);
        this.objects.addElement(pDFLink);
        PDFFileSpec pDFFileSpec = new PDFFileSpec(++this.objectcount, pDFLink.destination);
        this.objects.addElement(pDFFileSpec);
        PDFAction pDFAction = new PDFAction(++this.objectcount, pDFFileSpec);
        this.objects.addElement(pDFAction);
        pDFLink.setAction(pDFAction);
        return pDFLink;
    }

    public PDFStream makeStream() {
        PDFStream pDFStream = new PDFStream(++this.objectcount);
        this.objects.addElement(pDFStream);
        return pDFStream;
    }

    public PDFResources getResources() {
        return this.resources;
    }

    public void output(PrintWriter printWriter) throws IOException {
        this.position += this.outputHeader(printWriter);
        this.resources.setXObjects(this.xObjects);
        int n = 1;
        while (n <= this.objectcount) {
            this.location.addElement(new Integer(this.position));
            PDFObject pDFObject = (PDFObject)this.objects.elementAt(n - 1);
            this.position += pDFObject.output(printWriter);
            ++n;
        }
        this.position += this.outputXref(printWriter);
        this.outputTrailer(printWriter);
        printWriter.flush();
    }

    protected int outputHeader(PrintWriter printWriter) throws IOException {
        String string = "%PDF-1.2\n";
        printWriter.write(string);
        return string.length();
    }

    protected void outputTrailer(PrintWriter printWriter) throws IOException {
        String string = "trailer\n<<\n/Size " + (this.objectcount + 1) + "\n/Root " + this.root.number + " " + this.root.generation + " R\n/Info " + this.info.number + " " + this.info.generation + " R\n>>\nstartxref\n" + this.xref + "\n%%EOF\n";
        printWriter.write(string);
    }

    private int outputXref(PrintWriter printWriter) throws IOException {
        this.xref = this.position;
        StringBuffer stringBuffer = new StringBuffer("xref\n0 " + (this.objectcount + 1) + "\n0000000000 65535 f \n");
        int n = 1;
        while (n < this.objectcount + 1) {
            String string = "0000000000";
            String string2 = this.location.elementAt(n - 1).toString();
            String string3 = string.substring(string2.length()) + string2;
            stringBuffer = stringBuffer.append(string3 + " 00000 n \n");
            ++n;
        }
        printWriter.write(stringBuffer.toString());
        return stringBuffer.length();
    }
}

