/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.fop.pdf.PDFFont;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFXObject;

public class PDFResources
extends PDFObject {
    protected Hashtable fonts = new Hashtable();
    protected Vector xObjects;

    public PDFResources(int n) {
        super(n);
    }

    public void addFont(PDFFont pDFFont) {
        this.fonts.put(pDFFont.getName(), pDFFont);
    }

    public void setXObjects(Vector vector) {
        this.xObjects = vector;
    }

    public String toPDF() {
        StringBuffer stringBuffer = new StringBuffer(this.number + " " + this.generation + " obj\n<< /Font << ");
        Enumeration enumeration = this.fonts.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer = stringBuffer.append("/" + string + " " + ((PDFFont)this.fonts.get(string)).referencePDF() + "\n");
        }
        stringBuffer = stringBuffer.append(">>\n/ProcSet [ /PDF /ImageC /Text ] ");
        if (!this.xObjects.isEmpty()) {
            stringBuffer = stringBuffer.append("/XObject <<");
            int n = 1;
            while (n < this.xObjects.size()) {
                stringBuffer = stringBuffer.append("/Im" + n + " " + ((PDFXObject)this.xObjects.elementAt(n - 1)).referencePDF() + " \n");
                ++n;
            }
        }
        stringBuffer = stringBuffer.append(">>\nendobj\n");
        return stringBuffer.toString();
    }
}

