/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.awt;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageArea;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.AreaTree;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.DisplaySpace;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.InlineArea;
import org.apache.fop.layout.InlineSpace;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.RuleArea;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.pdf.FontSetup;
import org.apache.fop.svg.SVGArea;
import org.apache.fop.viewer.DocumentPanel;
import org.apache.fop.viewer.ProgressListener;
import org.apache.fop.viewer.Translator;

public class AWTRenderer
implements Renderer,
Printable,
Pageable {
    protected int pageWidth = 0;
    protected int pageHeight = 0;
    protected double scaleFactor = 100.0;
    protected int pageNumber = 0;
    protected AreaTree tree;
    protected ProgressListener progressListener = null;
    protected Translator res = null;
    protected Hashtable fontNames = new Hashtable();
    protected Hashtable fontStyles = new Hashtable();
    protected static Hashtable JAVA_FONT_NAMES = new Hashtable();
    protected Graphics2D graphics = null;
    protected DocumentPanel documentPanel = null;
    protected String currentFontName;
    protected int currentFontSize;
    protected float currentRed = 0.0f;
    protected float currentGreen = 0.0f;
    protected float currentBlue = 0.0f;
    protected int currentYPosition = 0;
    protected int currentXPosition = 0;
    private int currentAreaContainerXPosition = 0;

    public AWTRenderer(Translator translator) {
        this.res = translator;
    }

    public void setGraphics(Graphics2D graphics2D) {
        this.graphics = graphics2D;
        if (this.graphics != null) {
            this.graphics = graphics2D;
            this.graphics.setColor(Color.red);
        }
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int n) {
        this.pageNumber = n;
        if (this.documentPanel == null) {
            return;
        }
        this.documentPanel.updateSize(this.pageNumber, this.scaleFactor / 100.0);
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
        if (this.documentPanel == null) {
            return;
        }
        this.documentPanel.updateSize(this.pageNumber, this.scaleFactor / 100.0);
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void transform(Graphics2D graphics2D, double d, double d2) {
        AffineTransform affineTransform = graphics2D.getTransform();
        affineTransform.rotate(d2);
        affineTransform.scale(d / 100.0, d / 100.0);
        graphics2D.setTransform(affineTransform);
    }

    protected void drawFrame() {
        int n = this.pageWidth;
        int n2 = this.pageHeight;
        this.graphics.setColor(Color.white);
        this.graphics.fillRect(0, 0, n, n2);
        this.graphics.setColor(Color.black);
        this.graphics.drawRect(-1, -1, n + 2, n2 + 2);
        this.graphics.drawLine(n + 2, 0, n + 2, n2 + 2);
        this.graphics.drawLine(n + 3, 1, n + 3, n2 + 3);
        this.graphics.drawLine(0, n2 + 2, n + 2, n2 + 2);
        this.graphics.drawLine(1, n2 + 3, n + 3, n2 + 3);
    }

    public void render(AreaTree areaTree, PrintWriter printWriter) throws IOException {
        this.tree = areaTree;
        this.documentPanel.setAreaTree(areaTree);
        this.documentPanel.setPageCount(areaTree.getPages().size());
        this.documentPanel.setPageNumber(0);
        this.documentPanel.updateSize(this.pageNumber, this.scaleFactor / 100.0);
    }

    public void render(AreaTree areaTree, int n) throws IOException {
        this.tree = areaTree;
        Page page = (Page)areaTree.getPages().elementAt(n);
        this.pageWidth = (int)((float)page.getWidth() / 1000.0f);
        this.pageHeight = (int)((float)page.getHeight() / 1000.0f);
        this.transform(this.graphics, this.scaleFactor, 0.0);
        this.drawFrame();
        this.renderPage(page);
    }

    public void renderPage(Page page) {
        AreaContainer areaContainer = page.getBody();
        AreaContainer areaContainer2 = page.getBefore();
        AreaContainer areaContainer3 = page.getAfter();
        this.currentFontName = "";
        this.currentFontSize = 0;
        this.renderAreaContainer(areaContainer);
        if (areaContainer2 != null) {
            this.renderAreaContainer(areaContainer2);
        }
        if (areaContainer3 != null) {
            this.renderAreaContainer(areaContainer3);
        }
    }

    public void renderAreaContainer(AreaContainer areaContainer) {
        this.currentYPosition = areaContainer.getYPosition();
        this.currentAreaContainerXPosition = areaContainer.getXPosition();
        Enumeration enumeration = areaContainer.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
    }

    protected Rectangle2D getBounds(Area area) {
        return new Rectangle2D.Double(this.currentAreaContainerXPosition, this.currentYPosition, area.getAllocationWidth(), area.getHeight());
    }

    public void renderBlockArea(BlockArea blockArea) {
        Object object;
        Object object2;
        int n = this.currentAreaContainerXPosition + blockArea.getStartIndent();
        int n2 = this.currentYPosition;
        int n3 = blockArea.getContentWidth();
        int n4 = blockArea.getHeight();
        ColorType colorType = blockArea.getBackgroundColor();
        if (colorType != null && colorType.alpha() == 0.0f) {
            object2 = this.graphics.getColor();
            object = AWTRenderer.colorType2Color(colorType);
            this.graphics.setColor((Color)object);
            this.graphics.fillRect((int)((float)n / 1000.0f), (int)((float)this.pageHeight - (float)n2 / 1000.0f), (int)((float)n3 / 1000.0f), (int)((float)n4 / 1000.0f));
            this.graphics.setColor((Color)object2);
        }
        object2 = blockArea.getChildren().elements();
        while (object2.hasMoreElements()) {
            object = (Box)object2.nextElement();
            ((Box)object).render(this);
        }
    }

    public void setupFontInfo(FontInfo fontInfo) {
        FontSetup.setup(fontInfo);
        Hashtable hashtable = fontInfo.getFonts();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            int n;
            int n2 = 0;
            Object k = enumeration.nextElement();
            org.apache.fop.render.pdf.Font font = (org.apache.fop.render.pdf.Font)hashtable.get(k);
            String string = font.fontName();
            if (string.toUpperCase().indexOf("BOLD") > 0) {
                ++n2;
            }
            if (string.toUpperCase().indexOf("ITALIC") > 0 || string.toUpperCase().indexOf("OBLIQUE") > 0) {
                n2 += 2;
            }
            n = (n = string.indexOf("-")) < 0 ? string.length() : n;
            this.fontNames.put(k, string.substring(0, n));
            this.fontStyles.put(k, new Integer(n2));
        }
    }

    public void renderDisplaySpace(DisplaySpace displaySpace) {
        int n = displaySpace.getSize();
        this.currentYPosition -= n;
    }

    public void renderImageArea(ImageArea imageArea) {
        int n = this.currentAreaContainerXPosition + imageArea.getXOffset();
        int n2 = this.currentYPosition;
        int n3 = imageArea.getContentWidth();
        int n4 = imageArea.getHeight();
        FopImage fopImage = imageArea.getImage();
        if (fopImage == null) {
            System.out.println("area.getImage() is null");
        }
        int[] nArray = fopImage.getimagemap();
        String string = fopImage.gethref();
        ImageIcon imageIcon = new ImageIcon(string);
        Image image = imageIcon.getImage();
        this.graphics.drawImage(image, this.currentXPosition / 1000, this.pageHeight - n2 / 1000, fopImage.getWidth() / 1000, fopImage.getHeight() / 1000, null);
        this.currentYPosition -= n4;
    }

    public void renderInlineArea(InlineArea inlineArea) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = inlineArea.getFontState().getFontName();
        int n = inlineArea.getFontState().getFontSize();
        float f = inlineArea.getRed();
        float f2 = inlineArea.getGreen();
        float f3 = inlineArea.getBlue();
        if (!string.equals(this.currentFontName) || n != this.currentFontSize) {
            this.currentFontName = string;
            this.currentFontSize = n;
        }
        if (f != this.currentRed || f2 != this.currentGreen || f3 != this.currentBlue) {
            this.currentRed = f;
            this.currentGreen = f2;
            this.currentBlue = f3;
        }
        int n2 = this.currentXPosition;
        int n3 = this.currentYPosition;
        String string2 = inlineArea.getText();
        Color color = this.graphics.getColor();
        Font font = this.graphics.getFont();
        String string3 = this.fontNames.get(string).toString();
        string3 = this.getJavaFontName(string3);
        Font font2 = new Font(string3, (int)((Integer)this.fontStyles.get(string)), (int)((float)n / 1000.0f));
        this.graphics.setColor(new Color(f, f2, f3));
        this.graphics.setFont(font2);
        this.graphics.drawString(string2, (float)n2 / 1000.0f, (float)((int)((float)this.pageHeight - (float)n3 / 1000.0f)));
        this.graphics.setFont(font);
        this.graphics.setColor(color);
        this.currentXPosition += inlineArea.getContentWidth();
    }

    public void renderInlineSpace(InlineSpace inlineSpace) {
        this.currentXPosition += inlineSpace.getSize();
    }

    public void renderLineArea(LineArea lineArea) {
        int n = this.currentAreaContainerXPosition + lineArea.getStartIndent();
        int n2 = this.currentYPosition;
        int n3 = lineArea.getContentWidth();
        int n4 = lineArea.getHeight();
        this.currentYPosition -= lineArea.getPlacementOffset();
        this.currentXPosition = n;
        int n5 = this.currentYPosition;
        Enumeration enumeration = lineArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
        this.currentYPosition = n2 - n4;
    }

    public void renderRuleArea(RuleArea ruleArea) {
        int n = this.currentAreaContainerXPosition + ruleArea.getStartIndent();
        int n2 = this.currentYPosition;
        int n3 = ruleArea.getContentWidth();
        int n4 = ruleArea.getHeight();
        int n5 = ruleArea.getRuleThickness();
        float f = ruleArea.getRed();
        float f2 = ruleArea.getGreen();
        float f3 = ruleArea.getBlue();
        Color color = this.graphics.getColor();
        this.graphics.setColor(new Color(f, f2, f3));
        this.graphics.fillRect((int)((float)n / 1000.0f), (int)((float)this.pageHeight - (float)n2 / 1000.0f), (int)((float)n3 / 1000.0f), (int)((float)n5 / 1000.0f));
        this.graphics.setColor(color);
    }

    public void renderSVGArea(SVGArea sVGArea) {
        int n = this.currentAreaContainerXPosition;
        int n2 = this.currentYPosition;
        int n3 = sVGArea.getContentWidth();
        int n4 = sVGArea.getHeight();
        this.currentYPosition -= n4;
    }

    protected String getJavaFontName(String string) {
        if (string == null) {
            return null;
        }
        Object v = JAVA_FONT_NAMES.get(string);
        return v == null ? string : v.toString();
    }

    public void setProducer(String string) {
    }

    public void setComponent(DocumentPanel documentPanel) {
        this.documentPanel = documentPanel;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= this.tree.getPages().size()) {
            return 1;
        }
        Graphics2D graphics2D = this.graphics;
        int n2 = this.pageNumber;
        this.graphics = (Graphics2D)graphics;
        Page page = (Page)this.tree.getPages().elementAt(n);
        this.renderPage(page);
        this.graphics = graphics2D;
        return 0;
    }

    public int getNumberOfPages() {
        return this.tree.getPages().size();
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        if (n >= this.tree.getPages().size()) {
            return null;
        }
        Page page = (Page)this.tree.getPages().elementAt(n);
        PageFormat pageFormat = new PageFormat();
        Paper paper = new Paper();
        paper.setImageableArea(0.0, 0.0, (double)page.getWidth() / 1000.0, (double)page.getHeight() / 1000.0);
        paper.setSize((double)page.getWidth() / 1000.0, (double)page.getHeight() / 1000.0);
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public static Color colorType2Color(ColorType colorType) {
        if (colorType == null) {
            return null;
        }
        return new Color(colorType.red(), colorType.green(), colorType.blue());
    }

    static {
        JAVA_FONT_NAMES.put("Times", "serif");
        JAVA_FONT_NAMES.put("Times-Roman", "serif");
        JAVA_FONT_NAMES.put("Courier", "monospaced");
        JAVA_FONT_NAMES.put("Helvetica", "sansserif");
    }
}

